<?php

/**

 * @package sevenfigureteamsystem

 * @version 1.6.7

 */

/*

Plugin Name: 7-Figure Team System

Plugin URI: http://7figureteamsystem.com

Description: The 7-Figure Team System Plugin allows you to leverage your Network Marketing team to help everyone build their business & downline faster.

Version: 1.6.7

Author: Gavin Mountford

Author URI: http://7figureteamsystem.com

Author Email: gavin@wealthwithgavin.com

Author Plugin URI: http://7figureteamsystem.com

License: Commercial license.

*/

require_once 'infusionsoft/setup.php';

register_activation_hook( __FILE__, 'sevenfigureteamsystem_plugin_activation' );

function sevenfigureteamsystem_plugin_activation() {
    if ( ! wp_next_scheduled( 'sevenfigureteamsystem_infusionsoft_schedule_process_queue' ) ) {
        wp_schedule_event( time(), 'every_5_minutes', 'sevenfigureteamsystem_infusionsoft_schedule_process_queue' );
    }
}



class WpMobe{



	private $_titleARConfigPage = "Autoresponder Code";



	private $_slugARConfigPage = "autoresponder-code";



	private $_shortName = "wp-mobe";



	private $_userLogged;



	private $_tblARData = "mobe_ar_data";



	/*

	 * @var string  Plugin database version

	 */

	private $_dbVersion = '1.0.0';



	/*

	 * $var string  Plugin database option name

	 */

	private $_dbOptionName = 'wp_mobe_db_version';



	private $_exportCSVFolder = "export";



	/**

     * Create a new instance

     */

	function __construct(){

		global $wpdb;



		$this->createAdminPage();

		$this->handleShortcode();

		$this->registerAjax();

		$this->registerScriptAndStyle();

		$this->handleDataSubmit();



		$this->_tblARData = $wpdb->prefix . $this->_tblARData;

		$this->_upgrade();



		$this->_exportCSVFolder = plugin_dir_path( __FILE__ ) . $this->_exportCSVFolder . "/";

		if(!is_dir($this->_exportCSVFolder))

			mkdir($this->_exportCSVFolder);

		@chmod($this->_exportCSVFolder, 0777);

	}



	/*****************************

	 *

	 * Admin Menu Functions

	 *

	*****************************/



	/**

	 * Hook to create config page in WP backend

	 *

	 */

	function createAdminPage(){

		add_action("admin_menu", array($this, "_createAdminPage"));

	}



	function _createAdminPage(){



	}



	/*****************************

	 *

	 * Shortcode Functions

	 *

	*****************************/

	function handleShortcode(){

	}



	/*****************************

	 *

	 * Ajax Functions

	 *

	*****************************/



	/**

	 * Hook to handle ajax calling from plugin

	 *

	 */

	function registerAjax(){

	}



	/*****************************

	 *

	 * Script And Style Functions

	 *

	*****************************/



	/**

	 * Hook to load javascript and css

	 *

	 */

	function registerScriptAndStyle(){

		add_action( 'admin_enqueue_scripts', array($this, "_handleBackendScriptAndStyle") );

		add_action( 'wp_enqueue_scripts', array($this, "_handleFrontendScriptAndStyle") );

		add_action( 'wp_head', array($this, "_handleFrontendInternalScriptAndStyle") );

	}



	function _handleBackendScriptAndStyle(){

		wp_enqueue_script( $this->_shortName . '-script', plugins_url('assets/js/backend/main.js', __FILE__), array('jquery'), rand(), true );

		wp_localize_script( $this->_shortName . '-script', 'ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

		wp_enqueue_style( $this->_shortName . '-admin-style', plugins_url("assets/css/admin-style.css", __FILE__), array(), rand() );

	}



	function _handleFrontendScriptAndStyle(){

	}



	function _handleFrontendInternalScriptAndStyle(){

	}



	/*

	 * Generate database function

	 */

	private function _upgrade() {

		$upgraded = false;

		if ( $this->_needUpgrade('1.0.0') ) {

			$upgraded = $this->_upgrade100();

		}



		if ( $upgraded )

			update_option($this->_dbOptionName, $this->_dbVersion());

	}



	/**

	 * Hook to handle link cron

	 *

	 */

	function handleDataSubmit(){

		add_action("init", array($this, "_handleDataSubmit"));

	}



	function _handleDataSubmit(){

		global $wpdb;

		$this->_userLogged = wp_get_current_user();



		if(isset($_POST['wp_mobe_ar_data_export'])){

			$sql = "SELECT ar.data, ar.created_date, users.user_login FROM {$this->_tblARData} AS ar INNER JOIN {$wpdb->users} AS users ON ar.user_id = users.ID ORDER BY users.user_login, ar.created_date";

			$data = $wpdb->get_results($sql);



			$fileCSV = $this->_exportCSVFolder . "export_" . time() . ".csv";

			$fp = @fopen($fileCSV, 'w');

			if($fp){

				fputcsv($fp, array('user', 'data', 'created'));

				if($data){

					foreach($data as $row){

						fputcsv($fp, array($row->user_login, $row->data, $row->created_date));

					}

				}



				fclose($fp);



				$content = file_get_contents($fileCSV);

				$this->_downloadSendHeaders("data_export_" . date("Y-m-d") . ".csv");

				echo $content;

				exit();

			}

		}

	}



	/*****************************

	 *

	 * Private Process Functions

	 *

	*****************************/



	private function _downloadSendHeaders($filename) {

	    // disable caching

	    $now = gmdate("D, d M Y H:i:s");

	    header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");

	    header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");

	    header("Last-Modified: {$now} GMT");



	    // force download

	    header("Content-Type: application/force-download");

	    header("Content-Type: application/octet-stream");

	    header("Content-Type: application/download");



	    // disposition / encoding on response body

	    header("Content-Disposition: attachment;filename={$filename}");

	    header("Content-Transfer-Encoding: binary");

	}



	/*

	 * Upgrade database version 1.0.0

	 *

	 * Add table key

	 *

	 */

	private function _upgrade100() {

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

		global $wpdb;



		$table_name = $this->_tblARData;

		$sql = "CREATE TABLE $table_name (

			id bigint(20) NOT NULL AUTO_INCREMENT,

			user_id bigint(20) NOT NULL,

			created_date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

			data text NOT NULL,

			PRIMARY KEY  id (id)

		);";

		dbDelta($sql);



		return true;

	}



	/*

	 * Get plugin's db version

	 *

	 * @return string  Plugin DB version

	 */

	private function _dbVersion() {

		return $this->_dbVersion;

	}



	/*

	 * Get current db version

	 *

	 * @return string  Current DB version

	 */

	private function _currentDbVersion() {

		return get_option($this->_dbOptionName);

	}



	/*

	 * Check need to upgrade

	 *

	 * @return boolean  true if need to upgrade, otherwise false will be returned

	 */

	private function _needUpgrade($version = '') {



		if ( !$version ) $version = $this->_dbVersion();



		return 1 == version_compare($this->_currentDbVersion(), $version, '<');

	}



	private function _debugVar($var){

		echo "<pre>";

		var_dump($var);

		echo "</pre>";

	}

}



if( ! class_exists( 'WP_List_Table' ) ) {

    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );

}

class WpMobeArDataTable extends WP_List_Table {



	function get_columns(){

		$columns = array();

		if (current_user_can( 'manage_options' ))

			$columns['user_id'] = "User";

		$columns = array_merge($columns, array(

			'data'    => 'Data',

			'created_date'      => 'Created'

		));

		return $columns;

	}



	function get_sortable_columns() {

		$sortable_columns = array();

		if (current_user_can( 'manage_options' ))

			$sortable_columns['user_id'] = array('user_login',false);



		$sortable_columns = array_merge($sortable_columns, array(

			'created_date'   => array('created_date',false)

		));

		return $sortable_columns;

	}



	function prepare_items() {

		global $wpdb;



		$itemsPerPage = 20;

		$currentPage = $this->get_pagenum();



		$columns = $this->get_columns();

		$hidden = array();

		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array($columns, $hidden, $sortable);



		$sql = $this->prepare_sql($currentPage, $itemsPerPage);



		$this->items = $wpdb->get_results($sql);

		$totalItems = $wpdb->get_var("SELECT FOUND_ROWS()");



		$this->set_pagination_args( array(

			'total_items' => $totalItems,

			'per_page'    => $itemsPerPage

		) );

	}



	function prepare_sql($currentPage, $itemsPerPage){

		global $wpdb;



		$tableArData = $wpdb->prefix . "mobe_ar_data";

		$tableUser = $wpdb->prefix . "users";

		$userLogged = wp_get_current_user();

		$orderby = ( ! empty( $_GET['orderby'] ) ) ? $_GET['orderby'] : 'created_date';

		// If no order, default to asc

		$order = ( ! empty($_GET['order'] ) ) ? $_GET['order'] : 'desc';



		$offset = ($currentPage - 1) * $itemsPerPage;

		$sql = "SELECT SQL_CALC_FOUND_ROWS ar.data, ar.created_date, users.user_login FROM $tableArData AS ar INNER JOIN $tableUser AS users ON ar.user_id = users.ID";

		if (!current_user_can( 'manage_options' ))

			$sql .= " WHERE ar.user_id = " . $userLogged->ID;

		else{

			if( $_GET['user-filter'] > 0 ){

	            $sql .= ' where ar.user_id =' . $_GET['user-filter'];

	        }

		}

		$sql .= " ORDER BY $orderby $order LIMIT $offset, $itemsPerPage";



		return $sql;

	}



	function column_default( $item, $column_name ) {

		switch( $column_name ) {

			case 'user_id':

				return $item->user_login;

			case 'data':

				$dataReturn = "<div class='wp_mobe_ar_data'>";

				$data = maybe_unserialize($item->data);

				foreach($data as $label => $value){

					if(is_array($value))

						$value = maybe_serialize($value);

					$dataReturn .= "<div class='wp_mobe_ar_data_item'>";

					$dataReturn .= "<div class='wp_mobe_ar_data_label'>$label</div>";

					$dataReturn .= "<div class='wp_mobe_ar_data_value'>$value</div>";

					$dataReturn .= "</div>";

				}

				$dataReturn .= "</div>";

				return $dataReturn;

			case 'created_date':

				return $item->$column_name;

			default:



		}

	}



	function extra_tablenav( $which ) {

	    global $wpdb;

	    $table = $wpdb->prefix . "users";

	    $move_on_url = '&user-filter=';

	    if ( $which == "top" && current_user_can( 'manage_options' ) ){

	        ?>

	        <div class="alignleft actions bulkactions">

	        <?php

	        $cats = $wpdb->get_results('select * from '.$table.' order by user_login asc', ARRAY_A);

	        if( $cats ){

	            ?>

	            <select name="user-filter" class="ewc-filter-user">

	                <option value="">Filter by User</option>

	                <?php

	                foreach( $cats as $cat ){

	                    $selected = '';

	                    if( $_GET['user-filter'] == $cat['ID'] ){

	                        $selected = ' selected = "selected"';

	                    }

	                ?>

	                <option value="<?php echo $move_on_url . $cat['ID']; ?>" <?php echo $selected; ?>><?php echo $cat['user_login']; ?></option>

	                <?php

	                }

	                ?>

	            </select>

	            <?php

	        }

	        ?>

	        	<form class="form-export-csv" action="" method="post"><input class="button" type="submit" name="wp_mobe_ar_data_export" value="Export to csv" /></form>

	        </div>

	        <?php

	    }

	    if ( $which == "bottom" ){

	        //The code that goes after the table is there

	    }

	}

}

function sevenfigureteamsystem_show_ar_data_page(){

	$arDataListTable = new WpMobeArDataTable();

	echo '<div class="wrap wp_mobe_ar_data"><h2>Autoresponder Data</h2>';

	$arDataListTable->prepare_items();

	$arDataListTable->display();

	echo '</div>';

}



global $wpMobiObj;

$wpMobiObj = new WpMobe();



//Declare global variables

global $sevenfigureteamsystem_number_of_opportunities;

global $sevenfigureteamsystem_number_of_urls;

$sevenfigureteamsystem_number_of_opportunities = 5;

if(in_array($_SERVER['HTTP_HOST'], array('www.theonlinealliance.com', 'theonlinealliance.com'))){

	$sevenfigureteamsystem_number_of_opportunities = 5;

}

$sevenfigureteamsystem_number_of_urls = 5;

global $sevenfigureteamsystem_remote_activate_url;

global $sevenfigureteamsystem_shortname;

global $sevenfigureteamsystem_name;

global $sevenfigureteamsystem_license_key_option_name;

global $sevenfigureteamsystem_license_option_name;

global $license_notice;

$sevenfigureteamsystem_remote_activate_url = 'http://networkingsuperstars.com/?action=active';

$sevenfigureteamsystem_name = "7-Figure Team System";

$sevenfigureteamsystem_shortname =  "7figureteamsystem";

$sevenfigureteamsystem_license_key_option_name = $shortname . '_license_key';

$license_option_name = get_home_url() . "/" . $shortname;

$license_option_name = str_replace("https", "http", $license_option_name);

$sevenfigureteamsystem_license_option_name = md5($license_option_name);

$license_notice = 'Please activate to use this plugin';

// Add settings page

add_action('admin_menu', 'sevenfigureteamsystem_cookie_menu', 98);

function sevenfigureteamsystem_cookie_menu() {

	if(sevenfigureteamsystem_is_activated()){

		add_options_page( '7-Figure Team System', '7-Figure Team System config', 'manage_options', 'sevenfigureteamsystem', 'sevenfigureteamsystem_cookie_setting');

		add_options_page( '7-Figure Team Autoresponder Data', '7-Figure Team Autoresponder Data', 'manage_options', 'sevenfigureteamsystem_ar_data', 'sevenfigureteamsystem_show_ar_data_page');

		add_options_page( '7-Figure Team System setting', '7-Figure Team System', 'level_0', 'sevenfigureteamsystem_setting', 'sevenfigureteamsystem_cookie_setting_user');

		add_options_page( '7-Figure Team Referrals', '7-Figure Team Referrals', 'level_0', 'sevenfigureteamsystem_referrals', 'sevenfigureteamsystem_referrals');

	}

	else{

		add_options_page( '7-Figure Team Activation', '7-Figure Team Activation', 'level_0', 'sevenfigureteamsystem_manage_license', 'sevenfigureteamsystem_manage_license');

	}

}

function sevenfigureteamsystem_cookie_setting_user() {

	global $sevenfigureteamsystem_number_of_opportunities;

	global $sevenfigureteamsystem_number_of_urls;

	global $license_notice;



	$user = wp_get_current_user();

	$uid = get_current_user_id();

	if(!sevenfigureteamsystem_is_activated()){

		echo '<div id="message" class="error"><p>'.$license_notice.'</p></div>';

	}

	?>

	<div class="wrap">

		<h2>7-Figure Team System settings</h2>

		<p>Hey <?php echo get_the_author_meta("display_name", $user->ID); ?>,</p><p> Welcome to your <?php echo get_bloginfo("name"); ?> back office. Your Referrer is <?php echo apply_filters('the_content', '[7figure-referrer]'); ?>. All links you will see on this Team Site will be theirs. If this is incorrect, please contact us at Support</p>

    <?php

    if ( $_POST['sevenfigureteamsystem_update'] == 'yes' ) {

		for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) {

			update_user_meta( $uid, 'sevenfigureteamsystem_cookie_values_'.$i, $_POST['sevenfigureteamsystem_cookie_values_'.$i] );

		}

		print '<div id="message" class="updated"><p>The settings has been updated.</p></div>';

	}

	?>

		<form action="" method="post">

			<table class="form-table">

				<tbody>





					<?php for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) : ?>

					<?php

						$sevenfigureteamsystem_title = get_option( 'sevenfigureteamsystem_title_'. $i, "");

					?>

					<?php if ($sevenfigureteamsystem_title != ""): ?>

					<tr valign="top">

						<th scope="row"><?php echo $i; ?>. <?php echo $sevenfigureteamsystem_title; ?></th>

						<td>

							<p><textarea class="large-text code" id="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>" cols="50" rows="2" name="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>"><?php echo get_user_meta( $uid, 'sevenfigureteamsystem_cookie_values_'.$i, true ); ?></textarea></p>

						</td>

					</tr>

					<?php endif; ?>

					<?php endfor; ?>



					<tr valign="top">

						<th scope="row">Your <?php echo get_bloginfo("name"); ?> Referral ID is</th>

						<td>

							<p><?php echo get_current_user_id(); ?></p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Your <?php echo get_bloginfo("name"); ?> Referral link is</th>

						<td>

							<p><a href="<?php echo site_url("/")."?uid=".get_current_user_id(); ?>" target="blank"><?php echo site_url("/")."?uid=".get_current_user_id(); ?></a>  (You can promote ANY page on the team site by adding /?uid=<?php echo get_current_user_id(); ?> to the end)</p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">External URLs to promote</th>

						<td>

							<?php for($i=1;$i<=$sevenfigureteamsystem_number_of_urls;$i++) :

								$url_title = get_option( 'sevenfigureteamsystem_external_url_title_'. $i, "");

								$url = site_url("/")."go/$i/?uid=".get_current_user_id();

							?>

								<p><?php if ($url_title != ""): ?><?php echo $i.'. '.$url_title; ?><br><a href="<?php echo $url; ?>" target="blank"><?php echo $url; ?></a><?php endif; ?></p>

							<?php endfor; ?>

						</td>

					</tr>



				</tbody>

			</table>

			<input type="hidden" name="sevenfigureteamsystem_update" value="yes" />

			<p class="submit"><input type="submit" value="Save" class="button button-primary" id="submit" name="submit"></p>

		</form>

	</div>

<?php

}



function sevenfigureteamsystem_referrals() {

	global $license_notice;

	$user = wp_get_current_user();

	$uid = get_current_user_id();

	if(!sevenfigureteamsystem_is_activated()){

		echo '<div id="message" class="error"><p>'.$license_notice.'</p></div>';

	}

	?>

	<div class="wrap">

		<h2>Your <?php echo get_bloginfo("name"); ?> Referrals</h2>

		<p>Your Referrer is <?php echo apply_filters('the_content', '[7figure-referrer]'); ?></p>

		<p>Your Referrals are:</p>

		<p>

		<?php

			$referral_users = get_users(array(

				'meta_key'     => 'referral',

				'meta_value'   => $uid,

				'meta_compare' => '=',

				'orderby'      => 'ID',

				'order'        => 'ASC'

			));

			if (count($referral_users)) {

				foreach($referral_users as $referral_user) {

					echo sprintf('<a href="%s" target="_blank">%s</a> - ID = %s - %s<br>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name, $referral_user->ID, $referral_user->user_email);

				}

			} else {

				echo "You have no referrals so far.";

			}

		?>

		</p>

    </div>

<?php

}



function sevenfigureteamsystem_cookie_setting() {

	global $sevenfigureteamsystem_number_of_opportunities;

	global $sevenfigureteamsystem_number_of_urls;

	global $license_notice;

	global $wpdb;

	$uid = get_current_user_id();



	if ( $_POST['sevenfigureteamsystem_update'] == 'yes' ) {

		if(!empty($_POST['delete_opportunity_iden'])){

			delete_option('sevenfigureteamsystem_title_'.$_POST['delete_opportunity_iden']);

			delete_option('sevenfigureteamsystem_option_'.$_POST['delete_opportunity_iden']);

			delete_option('sevenfigureteamsystem_cookie_domains_'.$_POST['delete_opportunity_iden']);

			delete_option('sevenfigureteamsystem_cookie_values_'.$_POST['delete_opportunity_iden']);

			delete_option('sevenfigureteamsystem_current_cookie_index_'.$_POST['delete_opportunity_iden']);

			//delete_option('sevenfigureteamsystem_external_url_'.$_POST['delete_opportunity_iden']);

			//delete_option('sevenfigureteamsystem_external_url_title_'.$_POST['delete_opportunity_iden']);

			//delete_user_meta( $uid, 'sevenfigureteamsystem_cookie_values_'.$_POST['delete_opportunity_iden'] );

			$conditionDelete = $wpdb->prepare('meta_key like %s', 'sevenfigureteamsystem_cookie_values_'.$_POST['delete_opportunity_iden']);

			$sqlDelete = "DELETE FROM {$wpdb->usermeta} WHERE $conditionDelete";

			$wpdb->query($sqlDelete);

			print '<div id="message" class="updated"><p>Opportunity ' . $_POST['delete_opportunity_iden'] . ' had been deleted.</p></div>';

		}

		else{

			update_option( 'sevenfigureteamsystem_profile_page', $_POST['sevenfigureteamsystem_profile_page'] );

			update_option( 'sevenfigureteamsystem_cookie_time', $_POST['sevenfigureteamsystem_cookie_time'] );

			update_option( 'sevenfigureteamsystem_default_referrer_rotate', $_POST['sevenfigureteamsystem_default_referrer_rotate'] );

			update_option( 'sevenfigureteamsystem_default_referrer_be', $_POST['sevenfigureteamsystem_default_referrer_be'] );

			update_option( 'sevenfigureteamsystem_number_of_opportunities', $_POST['sevenfigureteamsystem_number_of_opportunities'] );

			for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) {

				update_option( 'sevenfigureteamsystem_title_'.$i, $_POST['sevenfigureteamsystem_title_'.$i] );

				update_option( 'sevenfigureteamsystem_option_'.$i, $_POST['sevenfigureteamsystem_option_'.$i] );

				$domains = explode(',', $_POST['sevenfigureteamsystem_cookie_domains_'.$i]);

				$domains_full = array();

				//Replace http:// and https:// from domains

				foreach ($domains as $domain) {

					$domains_full[] = trim(str_replace(array("http://", "https://"), array("", ""), $domain));

				}

				$domains_all = implode(",", $domains_full);

				update_option( 'sevenfigureteamsystem_cookie_domains_'.$i,  $domains_all );

				update_option( 'sevenfigureteamsystem_cookie_values_'.$i, rtrim($_POST['sevenfigureteamsystem_cookie_values_'.$i], ",") );

			}

			for($i=1;$i<=$sevenfigureteamsystem_number_of_urls;$i++) {

				update_option( 'sevenfigureteamsystem_external_url_title_'.$i, $_POST['sevenfigureteamsystem_external_url_title_'.$i] );

				update_option( 'sevenfigureteamsystem_external_url_'.$i, $_POST['sevenfigureteamsystem_external_url_'.$i] );

			}

			update_option( 'sevenfigureteamsystem_first_or_last', $_POST['sevenfigureteamsystem_first_or_last'] );

			update_option( 'sevenfigureteamsystem_display_power', $_POST['sevenfigureteamsystem_display_power'] );

			update_option( 'sevenfigureteamsystem_power_url', $_POST['sevenfigureteamsystem_power_url'] );

			update_option( 'sevenfigureteamsystem_bottom_margin', $_POST['sevenfigureteamsystem_bottom_margin'] );

			print '<div id="message" class="updated"><p>The settings has been updated.</p></div>';

		}

	}

	if(!sevenfigureteamsystem_is_activated()){

		echo '<div id="message" class="error"><p>'.$license_notice.'</p></div>';

	}



	$args = array(

		'show_option_all'         => null, // string

		'show_option_none'        => null, // string

		'hide_if_only_one_author' => null, // string

		'orderby'                 => 'display_name',

		'order'                   => 'ASC',

		'include'                 => null, // string

		'exclude'                 => null, // string

		'multi'                   => false,

		'show'                    => 'display_name',

		'echo'                    => true,

		'selected'                => get_option('sevenfigureteamsystem_default_referrer_be', ''),

		'include_selected'        => false,

		'name'                    => 'sevenfigureteamsystem_default_referrer_be', // string

		'id'                      => 'sevenfigureteamsystem_default_referrer_be', // integer

		'class'                   => null, // string

		'blog_id'                 => $GLOBALS['blog_id'],

		'who'                     => null // string

	);

	?>

	<div class="wrap">

		<h2>7-Figure Team System settings</h2>

		<form action="" method="post" class="form-update-settings">

			<table class="form-table">

				<tbody>



					<tr valign="top">

						<th scope="row">Author page</th>

						<td>

							<?php wp_dropdown_pages(array(

								'name' => 'sevenfigureteamsystem_profile_page',

								'selected' => get_option( 'sevenfigureteamsystem_profile_page', false ),

							)); ?>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Cookie time</th>

						<td>

							<p><input type="number" class="small-text" value="<?php echo get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ); ?>" id="cookie_time" min="0" step="1" name="sevenfigureteamsystem_cookie_time"> seconds</p>

						</td>

					</tr>



                    <tr valign="top">

						<th scope="row">Default Rotate Referrer</th>

						<td>

							<p><textarea name="sevenfigureteamsystem_default_referrer_rotate" rows="2" cols="50" id="sevenfigureteamsystem_default_referrer_rotate" class="large-text code"><?php echo get_option('sevenfigureteamsystem_default_referrer_rotate', '')?></textarea></p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Default Referrer<br /><i>(using when add new user in BE)</i></th>

						<td><?php wp_dropdown_users( $args ); ?></td>

					</tr>



					<tr valign="top">

						<td colspan="2">

							Referral Link Type<br>ID: http://sample.com/launch/in.php?id=yourid<br>Subdomain: http://sub1234.sample.com/<br>Sub folder: http://sample.com/subfolder1234/<br>Middle ID Replacement: http://sample.com/yourid/1234<br>Append Unique ID: http://sample.com/page/yourid<br>Simple Replacement: http://sample.com/?id=YOURID&variable1=x&variable2=y<br><br>Domain (split by commas, not include http:// or http://www.)

						</td>

					</tr>



					<?php for($i=1; $i<=$sevenfigureteamsystem_number_of_opportunities; $i++) { ?>



					<?php if($i == 11 && $sevenfigureteamsystem_number_of_opportunities >= 11) : ?>

						<tr valign="top">

							<th scope="row" id="show_more_control" style="padding-top: 0px; cursor: pointer;color: #0074a2;text-decoration: underline;">Show More</th>

							<td>&nbsp;</td>

						</tr>

					<tbody id="show_more" class="show_more">

					<?php endif; ?>





					<tr valign="top">

						<th scope="row" style="white-space: nowrap;">Opp. <?php echo $i; ?>. Title (on user config form)</th>

						<td>

							<p><input type="text" class="medium-text" value="<?php echo get_option( 'sevenfigureteamsystem_title_'.$i, '' ); ?>" id="sevenfigureteamsystem_title_<?php echo $i; ?>" name="sevenfigureteamsystem_title_<?php echo $i; ?>"> leave blank to disable</p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row" style="white-space: nowrap;">Opp. <?php echo $i; ?>. Referral Link Type</th>

						<td>

							<p><select name="sevenfigureteamsystem_option_<?php echo $i; ?>">

							<?php

							$options_array = array("ID" => 1, "Subdomain" => 2, "Sub folder" => 3, "Middle ID Replacement" => 4, "Append Unique ID" => 5, "Simple Replacement" => 6);

							$sevenfigureteamsystem_option = get_option( 'sevenfigureteamsystem_option_'.$i, true );

							foreach($options_array as $option_key => $option_value) {

								if ($option_value == $sevenfigureteamsystem_option) {

									echo '<option value="'.$option_value.'" selected>'.$option_key.'</option>';

								} else {

									echo '<option value="'.$option_value.'">'.$option_key.'</option>';

								}

							}

							?>

							</select></p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Opp. <?php echo $i; ?>. Domain</th>

						<td>

							<p><textarea class="large-text code" id="sevenfigureteamsystem_cookie_domains_<?php echo $i; ?>" cols="50" rows="2" name="sevenfigureteamsystem_cookie_domains_<?php echo $i; ?>"><?php echo get_option( 'sevenfigureteamsystem_cookie_domains_'.$i, "" ); ?></textarea></p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Opp. <?php echo $i; ?>. Default Cookies</th>

						<td>

							<p><textarea class="large-text code" id="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>" cols="50" rows="2" name="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>"><?php echo get_option( 'sevenfigureteamsystem_cookie_values_'.$i, "" ); ?></textarea></p>

						</td>

					</tr>

					<tr valign="top">

						<th scope="row">Delete opportunity <?php echo $i; ?></th>

						<td>

							<input type='submit' value='Delete' class='delete-opportunity button button-primary' rel='<?php echo $i ?>' />

						</td>

					</tr>

					<?php if($i == $sevenfigureteamsystem_number_of_opportunities && $sevenfigureteamsystem_number_of_opportunities >= 11) : ?>

					</tbody>

					<?php endif; ?>

					<?php } ?>







					<tr valign="top">

						<th scope="row">First touch or last</th>

						<td>

							<p><select name="sevenfigureteamsystem_first_or_last">

							<?php

							$options_array = array("First touch" => 1, "Last touch" => 2);

							$sevenfigureteamsystem_option = get_option("sevenfigureteamsystem_first_or_last", 2);

							foreach($options_array as $option_key => $option_value) {

								if ($option_value == $sevenfigureteamsystem_option) {

									echo '<option value="'.$option_value.'" selected>'.$option_key.'</option>';

								} else {

									echo '<option value="'.$option_value.'">'.$option_key.'</option>';

								}

							}

							?>

							</select></p>

						</td>

					</tr>



					<tr valign="top">

						<th colspan="2">Please enter external URLs here: EG: Your FB FanPage, FBGroup, Webinar Registration Page link here:</th>

					</tr>

					<?php for ($i = 1; $i <= $sevenfigureteamsystem_number_of_urls; $i++) : ?>

					<tr valign="top">

						<th scope="row"><?php print $i; ?>. URL Title  (on user config page)</th>

						<td>

							<input type="text" class="medium-text" value="<?php echo get_option( 'sevenfigureteamsystem_external_url_title_'. $i, '' ); ?>" name="sevenfigureteamsystem_external_url_title_<?php print $i; ?>"> leave blank to disable

						</td>

					</tr>



					<tr valign="top">

						<th scope="row"><?php print $i; ?>. External URL</th>

						<td>

							<p><input type="text" class="medium-text" value="<?php echo get_option( 'sevenfigureteamsystem_external_url_'. $i, '' ); ?>" name="sevenfigureteamsystem_external_url_<?php print $i; ?>"> <?php echo site_url("/")."go/$i/?uid=".get_current_user_id(); ?></p>

						</td>

					</tr>

					<?php endfor; ?>



					<tr valign="top">

						<td colspan="2">

							Earn commissions for Team Site Traffic by entering your Team Site Traffic affiliate link here, which will be attached to the 'Powered By Team Site Traffic' footer text. Go here to signup for the affiliate program - <a href="http://teamsitetraffic.com/affiliates" target="_blank">http://teamsitetraffic.com/affiliates</a>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Display powered by text?</th>

						<td>

					<?php $sevenfigureteamsystem_display_power = get_option( 'sevenfigureteamsystem_display_power', true); ?>

							<p><input type="checkbox" name="sevenfigureteamsystem_display_power"<?php echo $sevenfigureteamsystem_display_power ? " checked": ""; ?> va1ue="1" /></p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Affiliate Url</th>

						<td>

							<p><input type="text" name="sevenfigureteamsystem_power_url" value="<?php echo get_option( 'sevenfigureteamsystem_power_url', 'http://7figureteamsystem.com' ); ?>" /></p>

						</td>

					</tr>



					<tr valign="top">

						<th scope="row">Bottom Margin</th>

						<td>

							<p><input type="text" name="sevenfigureteamsystem_bottom_margin" value="<?php echo get_option( 'sevenfigureteamsystem_bottom_margin', '20px' ); ?>" /> (please make sure you have px at the end)</p>

						</td>

					</tr>



				</tbody>

			</table>

			<input type="hidden" name="sevenfigureteamsystem_update" value="yes" />

			<input type="hidden" name="delete_opportunity_iden" id="delete_opportunity_iden" value="" />

			<p class="submit"><input type="submit" value="Save" class="button button-primary" id="submit" name="submit"></p>

		</form>

		<script type="text/javascript">

		(function ($) {

			var element = $('#show_more');

			if (element.hasClass('show_more')) {

				element.hide();

			}

			$('#show_more_control').click(function(e) {

				if (element.hasClass('show_more')) {

					element.removeClass('show_more').addClass('show_less').show(1000, function(){

						$('#show_more_control').text('Show less');

					});

				}else{

					element.removeClass('show_less').addClass('show_more').hide(1000, function() {

						$('#show_more_control').text('Show more');

					});

				}

			});

			$(".delete-opportunity").click(function(e){

				var iden = $(this).attr("rel");

				var form = $(this).parents(".form-update-settings");form.submit();

				var confirmChoose = confirm("Are you sure to delete this opportunity?");

				if(confirmChoose == true){

					$("#delete_opportunity_iden").attr("value", iden);

					return true;

				}

				else{

					e.preventDefault();

					return false;

				}

			});

		}(jQuery));

		</script>

	</div>

<?php

}



function sevenfigureteamsystem_manage_license() {

	global $sevenfigureteamsystem_shortname;

	global $sevenfigureteamsystem_name;

	if ( $_POST['activate'] ) {

		$license = stripslashes_deep($_POST['license']);



		if ( $license['key'] && $license['email'] ) {

			$result = sevenfigureteamsystem_do_remote_activate($license['key'], $sevenfigureteamsystem_shortname, $license['email']);



			if ( !is_wp_error($result) ) {

				echo "<script>window.location.href = '" . admin_url() . "'</script>";

			} else {

				echo '<div id="message" class="error"><p>'.$result->get_error_message().'</p></div>';

			}



		} else {

			echo '<div id="message" class="error"><p>Empty license Key or Email</p></div>';

		}

	} elseif ( $_POST['delete-license'] ) {

		if ( sevenfigureteamsystem_delete_license() ) {

			echo "<script>window.location.href = '" . admin_url() . "'</script>";

		}

	} else {

		$license = sevenfigureteamsystem_get_license_key();

	}



	?>

<div class="wrap">

<h2>License <?php echo sevenfigureteamsystem_is_activated() ? '' : 'Activation' ?></h2>



<?php if ( sevenfigureteamsystem_is_activated() ) : ?>

	<form action="" method="post">

		<table class="form-table">

			<tr>

				<th>Plugin:</th>

				<td>

					<!--<input type="textbox" name="license[name]" value="<?php echo $sevenfigureteamsystem_shortname?>" readonly="readonly" size="25" />-->

					<?php echo $sevenfigureteamsystem_name; ?> (<code><?php echo $sevenfigureteamsystem_shortname; ?></code>)

				</td>

			</tr>

			<tr>

				<th>Email:</th>

				<td>

					<code><?php echo $license['email'] ?></code>

				</td>

			</tr>

			<tr>

				<th>License Key:</th>

				<td>

					<code><?php echo $license['key'] ?></code>

				</td>

			</tr>

		</table>

		<p class="submit">

			<input type="submit" class="button-primary not-require-check-license" name="delete-license" value="Delete this license" />

		</p>

	</form>

<?php else : ?>

	<form action="" method="post">

		<table class="form-table">

			<tr>

				<th>Plugin:</th>

				<td>

					<?php echo $sevenfigureteamsystem_name; ?> (<code><?php echo $sevenfigureteamsystem_shortname; ?></code>)

				</td>

			</tr>

			<tr>

				<th>Email:</th>

				<td>

					<input type="textbox" class="regular-text code" name="license[email]" value="<?php echo $license['email'] ?>" size="50" />

				</td>

			</tr>

			<tr>

				<th>License Key:</th>

				<td>

					<input type="textbox" class="regular-text code" name="license[key]" value="<?php echo $license['key'] ?>" size="50" />

				</td>

			</tr>

		</table>

		<p class="submit">

			<input type="submit" class="button-primary not-require-check-license" name="activate" value="Activate" />

		</p>

	</form>

<?php endif; ?>

</div>

	<?php

}



function sevenfigureteamsystem_do_remote_activate($key, $plugin, $email) {

	$args = array(

		'key' => $key,

		'plugin' => $plugin,

		'email' => $email,

		'url' => get_home_url()

	);



	$remote_activate_url = sevenfigureteamsystem_build_activate_url($args);

	$return = file_get_contents($remote_activate_url);



	if( strpos($return,"Active success") === 0 ){

		sevenfigureteamsystem_set_license_key($key, $email);

		return sevenfigureteamsystem_set_activated();

	}



	return new WP_Error('license_activate_failed', $return);

}



function sevenfigureteamsystem_get_license_key() {

	global $sevenfigureteamsystem_license_key_option_name;

	return get_option($sevenfigureteamsystem_license_key_option_name, array('key' => '', 'email' => ''));

}

function sevenfigureteamsystem_set_license_key($key, $email) {

	global $sevenfigureteamsystem_license_key_option_name;

	return update_option($sevenfigureteamsystem_license_key_option_name, compact('key', 'email'));

}

function sevenfigureteamsystem_delete_license() {

	global $sevenfigureteamsystem_license_option_name;

	global $sevenfigureteamsystem_license_key_option_name;

	delete_option($sevenfigureteamsystem_license_option_name);

	update_option($sevenfigureteamsystem_license_key_option_name, array('key' => '', 'email' => ''));

	return true;

}



function sevenfigureteamsystem_build_activate_url($args) {

	global $sevenfigureteamsystem_remote_activate_url;

	return add_query_arg($args, $sevenfigureteamsystem_remote_activate_url);

}

function sevenfigureteamsystem_set_activated() {

	global $sevenfigureteamsystem_license_option_name;

	return update_option($sevenfigureteamsystem_license_option_name, 'yes');

}

function sevenfigureteamsystem_is_activated() {

	return true;

	global $sevenfigureteamsystem_license_option_name;

	$check = get_option($sevenfigureteamsystem_license_option_name, 'no');



	if ( $check == 'yes' )

		return true;



	return false;

	/*return true;*/

}

function sevenfigureteamsystem_admin_head(){

	$page = $_REQUEST['page'];

	$accessingMyPlugin = !empty($page) && in_array($page, array('sevenfigureteamsystem','sevenfigureteamsystem_setting','sevenfigureteamsystem_referrals'));

	if ( !sevenfigureteamsystem_is_activated() && $accessingMyPlugin ) {

	?>

<script type="text/javascript">

jQuery(function($) {

	$('.button-primary, .button-secondary', '.wrap').each(function(){

		if(!$(this).hasClass('not-require-check-license')){

			$(this).attr('disabled', 'disabled').click(function() {

				return false;

			});

		}

	});

})

</script>

	<?php

	}

}

add_action('admin_head', "sevenfigureteamsystem_admin_head");



add_action( 'init', 'set_sevenfigureteamsystem_cookie', 1 );

function set_sevenfigureteamsystem_cookie() {

	global $sevenfigureteamsystem_number_of_opportunities;

	global $sevenfigureteamsystem_cookie;

	//Here always set cookie for logged in user and return

	$current_user = wp_get_current_user();

	if ( $current_user->ID != 0) {

		$uidcookie = get_user_meta($current_user->ID, 'referral', true);

		//make sure user has meta referral

		//if(empty($uidcookie)){

		if($uidcookie === ""){

			$uidcookie = get_sevenfigureteamsystem_default_cookie(true);

			update_user_meta($current_user->ID, 'referral', esc_attr(stripslashes($uidcookie)));

		}

		$sevenfigureteamsystem_cookie = $uidcookie;

		setcookie('sevenfigureteamsystem_cookie', $uidcookie, time()+get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ), '/');

		return $uidcookie;

	}



	$uidcookie = get_sevenfigureteamsystem_default_cookie();

	$sevenfigureteamsystem_cookie = $uidcookie;



	return $uidcookie;

}



function get_sevenfigureteamsystem_default_cookie($addNew = false){

	//echo "<pre>";var_dump($_COOKIE);echo "</pre>";exit;

	$uidcookie = "";

	//Make sure it works for ID or Id as well

	if ($_GET['uid'] == "") {

		if ($_GET['Uid'] != "") $_GET['uid'] = $_GET['Uid'];

		if ($_GET['UId'] != "") $_GET['uid'] = $_GET['UId'];

		if ($_GET['UID'] != "") $_GET['uid'] = $_GET['UID'];

	}

	$sevenfigureteamsystem_first_or_last = get_option("sevenfigureteamsystem_first_or_last", 2);

	if ($sevenfigureteamsystem_first_or_last == 1) {

		//If 1 then first touch

		//First touch cookie instead of last touch cookie

		//Note that first touch but not default cookie, if default cookie we use last touch

		if ( $_COOKIE['sevenfigureteamsystem_cookie'] != '' && !$addNew ) {

			// The user id cookie is cookie

			$uidcookie = $_COOKIE['sevenfigureteamsystem_cookie'];

		} else {

			// Check if we have id

			if ( $_GET['uid'] != '' ) {

				// The value is s1

				$uidcookie = $_GET['uid'];

				// Add s1 to the cookie

				setcookie('sevenfigureteamsystem_cookie', $uidcookie, time()+get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ), '/');

			} else {

				// Assign default user id cookie - now don't set any default cookie

				$uidcookie = sevenfigureteamsystem_get_default_referrer();

				//$uidcookie = 1;

				//$sevenfigureteamsystem_cookie = $uidcookie;

				setcookie('sevenfigureteamsystem_cookie', $uidcookie, time()+get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ), '/');

			}

		}

	} else {

		//Last touch cookie instead of first touch cookie

		// Check if we have id

		if ( $_GET['uid'] != '' ) {

			// The value is s1

			$uidcookie = $_GET['uid'];

			// Add s1 to the cookie

			setcookie('sevenfigureteamsystem_cookie', $uidcookie, time()+get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ), '/');

		} elseif ( $_COOKIE['sevenfigureteamsystem_cookie'] != '' && !$addNew ) {

			// The user id cookie is cookie

			$uidcookie = $_COOKIE['sevenfigureteamsystem_cookie'];

		} else {

			// Assign default user id cookie - now don't set any default cookie

			$uidcookie = sevenfigureteamsystem_get_default_referrer();

			//$uidcookie = 1;

			//$sevenfigureteamsystem_cookie = $uidcookie;

			setcookie('sevenfigureteamsystem_cookie', $uidcookie, time()+get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ), '/');

		}

	}



	return $uidcookie;

}



function sevenfigureteamsystem_get_default_referrer($beforeReferrerIndexName = "sevenfigureteamsystem_before_referrer_index"){

	$referrerDefaultValues = get_option("sevenfigureteamsystem_default_referrer_rotate", "");

	$beforeReferrerIndex = get_option($beforeReferrerIndexName, "");



	if(!empty($referrerDefaultValues)){

		$referrerDefaultValues = explode(",",$referrerDefaultValues);

		foreach($referrerDefaultValues as &$value){

			$value = trim($value);

		}

		$index = 0;

		if($beforeReferrerIndex != ""){

			$index = array_search($beforeReferrerIndex, array_keys($referrerDefaultValues));

			if($index === false)

				$index = 0;

			else{

				$index += 1;

				if(!isset($referrerDefaultValues[$index]))

					$index = 0;

			}

		}



		update_option($beforeReferrerIndexName, $index);

		return $referrerDefaultValues[$index];

	}

	else{

		//Remove cookie

		update_option($beforeReferrerIndexName, "");

	}

	return false;

}



function sfts_id_replace_callback($matches) {

	global $cookie, $domain;

	$content_to_replace = $matches[3];

	$content_to_replace_array = explode('"', $content_to_replace, 2);

	$content_to_replace = $content_to_replace_array[0];

	$content_to_add = '"'.$content_to_replace_array[1];

	if ($content_to_replace_array[1]!="") $content_to_add .= '"';

	$content_to_replace = $content_to_replace.$cookie;

	return "<a".$matches[1].'href="'.$matches[2].$domain.$content_to_replace.$content_to_add;

}



function sfts_subdomain_replace_callback($matches) {

	global $cookie, $domain;

	return "<a".$matches[1].'href="'.$matches[2].$cookie.'.'.$domain.$matches[3].'"';

}



function sfts_subfolder_replace_callback($matches) {

	global $cookie, $domain;

	return "<a".$matches[1].'href="'.$matches[2].$domain.'/'.$cookie.'/'.$matches[3].'"';

}



function sfts_middle_replace_callback($matches) {

	global $cookie, $domain;

	$content_to_replace = $matches[3];

	$content_to_replace_array = explode('"', $content_to_replace, 2);

	$content_to_replace = $content_to_replace_array[0];

	$content_to_add = '"'.$content_to_replace_array[1];

	if ($content_to_replace_array[1]!="") $content_to_add .= '"';

	$lastchar = substr($content_to_replace, -1);

	//If we have last slash

	if ($lastchar == "/") {

		$content_to_replace_array = explode("/", $content_to_replace);

		$content_to_replace_array[count($content_to_replace_array)-3] = $cookie;

		$content_to_replace = implode("/", $content_to_replace_array);

	} else {

		$content_to_replace_array = explode("/", $content_to_replace);

		$content_to_replace_array[count($content_to_replace_array)-2] = $cookie;

		$content_to_replace = implode("/", $content_to_replace_array);

	}

	return "<a".$matches[1].'href="'.$matches[2].$domain.$content_to_replace.$content_to_add;

}



function sfts_appenduniqueid_replace_callback($matches) {

	global $cookie, $domain;

	$content_to_replace = $matches[3];

	$content_to_replace_array = explode('"', $content_to_replace, 2);

	$content_to_replace = $content_to_replace_array[0];

	$content_to_add = '"'.$content_to_replace_array[1];

	if ($content_to_replace_array[1]!="") $content_to_add .= '"';

	$lastchar = substr($content_to_replace, -1);

	//If we have last slash

	if ($lastchar == "/") {

		return "<a".$matches[1].'href="'.$matches[2].$domain.$content_to_replace.$cookie.$content_to_add;

	} else {

		return "<a".$matches[1].'href="'.$matches[2].$domain.$content_to_replace."/".$cookie.$content_to_add;

	}

}



function sfts_simple_replace_callback($matches) {

	global $cookie, $domain;

	if (strpos($matches[2], "YOURID.") !== false) {

		if ($cookie == "") return "<a".$matches[1].'href="'.str_replace("YOURID.", "", $matches[2]).$domain.$matches[3].$matches[4].'"';

	}

	return "<a".$matches[1].'href="'.str_replace("YOURID", $cookie, $matches[2].$domain.$matches[3].$matches[4]).'"';

}



function sevenfigureteamsystem_get_default_cookie($i) {

	global $cookie;

	$cookie = "";

	$inti = (int) $i;



    if(empty($_GET['uid']) && isset($_SESSION['sevenfigureteamsystem_current_cookie_'.$inti]) && !empty($_SESSION['sevenfigureteamsystem_current_cookie_'.$inti])){

		$cookie = $_SESSION['sevenfigureteamsystem_current_cookie_'.$inti];return;

	}



	$sevenfigureteamsystem_cookie_values = get_option('sevenfigureteamsystem_cookie_values_'.$inti, "");

	if ($sevenfigureteamsystem_cookie_values != ""):

		$sevenfigureteamsystem_cookie_values = rtrim($sevenfigureteamsystem_cookie_values, ",");

		$sevenfigureteamsystem_cookie_values = explode(',', $sevenfigureteamsystem_cookie_values);

		//Here we handle evenly cookie

		$number_of_cookies = count($sevenfigureteamsystem_cookie_values);

		$sevenfigureteamsystem_current_cookie_index = floor(get_option( 'sevenfigureteamsystem_current_cookie_index_'.$inti, true ));

		if ($sevenfigureteamsystem_current_cookie_index >= $number_of_cookies) $sevenfigureteamsystem_current_cookie_index = 0;

		$cookie = trim($sevenfigureteamsystem_cookie_values[$sevenfigureteamsystem_current_cookie_index]);

		$sevenfigureteamsystem_current_cookie_index++;

		update_option( 'sevenfigureteamsystem_current_cookie_index_'.$inti, $sevenfigureteamsystem_current_cookie_index );

                $_SESSION['sevenfigureteamsystem_current_cookie_'.$inti] = $cookie;

	endif;

}



function sevenfigureteamsystem_get_cookie($uid, $i) {

	global $sevenfigureteamsystem_number_of_urls;

	global $current_referral_arr;

	global $cookie;



	$cookie = "";

	$inti = (int) $i;



	if(empty($_GET['uid']) && isset($_SESSION['sevenfigureteamsystem_current_cookie_'.$inti]) && !empty($_SESSION['sevenfigureteamsystem_current_cookie_'.$inti])){

		$cookie = $_SESSION['sevenfigureteamsystem_current_cookie_'.$inti];return;

	}



	$sevenfigureteamsystem_cookie_values = get_user_meta($uid, 'sevenfigureteamsystem_cookie_values_'.$inti, true);

	if ($sevenfigureteamsystem_cookie_values != ""):

		$sevenfigureteamsystem_cookie_values = rtrim($sevenfigureteamsystem_cookie_values, ",");

		$sevenfigureteamsystem_cookie_values = explode(',', $sevenfigureteamsystem_cookie_values);

		//Here we handle evenly cookie

		$number_of_cookies = count($sevenfigureteamsystem_cookie_values);

		$sevenfigureteamsystem_current_cookie_index = floor(get_user_meta( $uid, 'sevenfigureteamsystem_current_cookie_index_'.$inti, true ));

		if ($sevenfigureteamsystem_current_cookie_index >= $number_of_cookies) $sevenfigureteamsystem_current_cookie_index = 0;

		$cookie = trim($sevenfigureteamsystem_cookie_values[$sevenfigureteamsystem_current_cookie_index]);

		$sevenfigureteamsystem_current_cookie_index++;

		update_user_meta( $uid, 'sevenfigureteamsystem_current_cookie_index_'.$inti, $sevenfigureteamsystem_current_cookie_index );

		$_SESSION['sevenfigureteamsystem_current_cookie_'.$inti] = $cookie;

	else:

		//Here we get that from referred user

		$referral_id = get_user_meta($uid, "referral", true);

		if ($referral_id != "") {

			if (in_array($referral_id, $current_referral_arr)) {

				sevenfigureteamsystem_get_default_cookie ($inti);

			} else {

				$current_referral_arr[] = $referral_id;

				sevenfigureteamsystem_get_cookie ($referral_id, $inti);

			}

		} else {

			sevenfigureteamsystem_get_default_cookie ($inti);

		}

	endif;

}



function sevenfigureteamsystem_cookie_content($content) {

	global $sevenfigureteamsystem_number_of_urls, $sevenfigureteamsystem_number_of_opportunities;

	global $sevenfigureteamsystem_cookie, $cookie, $domain;

	if(!sevenfigureteamsystem_is_activated())

		return $content;



	// Ok, now we have the cookie var is $cookie

	for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++):

		$sevenfigureteamsystem_title = get_option("sevenfigureteamsystem_title_".$i);

		if ($sevenfigureteamsystem_title != ""):

			global $current_referral_arr;

			$current_referral_arr = array();

			sevenfigureteamsystem_get_cookie($sevenfigureteamsystem_cookie, $i);

			// For each domain

			$domains = get_option( 'sevenfigureteamsystem_cookie_domains_'.$i, '7figureteamsystem.com' );

			$domains = explode(',', $domains);

			// Start to filter the content.

			$sevenfigureteamsystem_option = get_option("sevenfigureteamsystem_option_".$i, 1);



			$domains_full = array();

			//Replace http:// and https:// from domains

			foreach ($domains as $domain) {

				$domain_to_check = trim(str_replace(array("http://", "https://"), array("", ""), $domain));

				if ($domain_to_check != "") $domains_full[] = $domain_to_check;

			}



			foreach ($domains_full as $domain) {

				//ID way

				if ($sevenfigureteamsystem_option == 1) {

					$content = preg_replace_callback('/<a(.*)href="(.*)'.$domain.'(.*)"/i', "sfts_id_replace_callback", $content);

				}

				//Subdomain way

				if ($sevenfigureteamsystem_option == 2) {

					$content = preg_replace_callback('/<a(.*)href="(.*)'.$domain.'(.*)"/i', "sfts_subdomain_replace_callback", $content);

				}

				//Sub folder way

				if ($sevenfigureteamsystem_option == 3) {

					$content = preg_replace_callback('/<a(.*)href="(.*)'.$domain.'\/(.*)"/i', "sfts_subfolder_replace_callback", $content);

				}

				//Middle ID Replacement way

				if ($sevenfigureteamsystem_option == 4) {

					$content = preg_replace_callback('/<a(.*)href="(.*)'.$domain.'(.*)"/i', "sfts_middle_replace_callback", $content);

				}

				//Append Unique ID way

				if ($sevenfigureteamsystem_option == 5) {

					$content = preg_replace_callback('/<a(.*)href="(.*)'.$domain.'(.*)"/i', "sfts_appenduniqueid_replace_callback", $content);

				}

				//Simple Replacement way

				if ($sevenfigureteamsystem_option == 6) {

					$content = preg_replace_callback('/<a(.*)href="(.*)'.$domain.'(.*)"/i', "sfts_simple_replace_callback", $content);

				}

			}

		endif;

	endfor;



	return $content;

}

// Add filter to the content

add_filter( 'the_content', 'sevenfigureteamsystem_cookie_content', 9999 );



// Add filter to the widget text

add_filter( 'widget_text', 'sevenfigureteamsystem_cookie_content' );



function sevenfigureteamsystem_scripts () {

	wp_enqueue_style( 'teamsite', site_url("/wp-content/plugins/7figureteamsystem/assets/css/7figureteamsystem.css"), array(), "1.1" );

}

add_action( 'wp_enqueue_scripts', 'sevenfigureteamsystem_scripts' );



function sevenfigureteamsystem_powered_by() {

	$show = get_option("sevenfigureteamsystem_display_power", true);

	$url = get_option("sevenfigureteamsystem_power_url", "");

	$bottom_margin = get_option("sevenfigureteamsystem_bottom_margin", "20px");

	if ($url == "") $url = "http://teamsitetraffic.com";

	if ($show) {

	?>

    <div id="team_powered_by" style="margin-top: <?php echo $bottom_margin; ?>"><a href="<?php echo $url; ?>" target="_blank">7-Figure Team System</a><br /><br /><a href="<?php echo $url; ?>" target="_blank"><img src="<?php echo site_url("/wp-content/plugins/7figureteamsystem/assets/images/7-FigureTeamSystem-com_footer.png"); ?>" /></a></div>

    <?php

	}



        global $sevenfigureteamsystem_number_of_urls;

	for($i = 1; $i <= $sevenfigureteamsystem_number_of_urls; $i++){

		unset($_SESSION['sevenfigureteamsystem_current_cookie_'.$i]);

	}

}

add_action('wp_footer', 'sevenfigureteamsystem_powered_by', 1);





/*AUTO UPDATE SECION*/

$api_url = 'http://teamsitetraffic.com/7figureteamsystem_plugin_update/';

$plugin_slug = basename(dirname(__FILE__));





// Take over the update check

add_filter('pre_set_site_transient_update_plugins', 'sevenfigureteamsystem_check_for_plugin_update');



function sevenfigureteamsystem_check_for_plugin_update($checked_data) {

	global $api_url, $plugin_slug, $wp_version;



	//Comment out these two lines during testing.

	if (empty($checked_data->checked))

		return $checked_data;



	$args = array(

		'slug' => $plugin_slug,

		'version' => $checked_data->checked[$plugin_slug .'/'. $plugin_slug .'.php'],

	);

	$request_string = array(

			'body' => array(

				'action' => 'basic_check',

				'request' => serialize($args),

				'api-key' => md5(get_bloginfo('url'))

			),

			'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')

		);



	// Start checking for an update

	$raw_response = wp_remote_post($api_url, $request_string);



	if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200))

		$response = unserialize($raw_response['body']);



	if (is_object($response) && !empty($response)) // Feed the update data into WP updater

		$checked_data->response[$plugin_slug .'/'. $plugin_slug .'.php'] = $response;



	return $checked_data;

}





// Take over the Plugin info screen

add_filter('plugins_api', 'sevenfigureteamsystem_plugin_api_call', 10, 3);



function sevenfigureteamsystem_plugin_api_call($def, $action, $args) {

	global $plugin_slug, $api_url, $wp_version;



	if (!isset($args->slug) || ($args->slug != $plugin_slug))

		return false;



	// Get the current version

	$plugin_info = get_site_transient('update_plugins');

	$current_version = $plugin_info->checked[$plugin_slug .'/'. $plugin_slug .'.php'];

	$args->version = $current_version;



	$request_string = array(

			'body' => array(

				'action' => $action,

				'request' => serialize($args),

				'api-key' => md5(get_bloginfo('url'))

			),

			'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')

		);



	$request = wp_remote_post($api_url, $request_string);



	if (is_wp_error($request)) {

		$res = new WP_Error('plugins_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>'), $request->get_error_message());

	} else {

		$res = unserialize($request['body']);



		if ($res === false)

			$res = new WP_Error('plugins_api_failed', __('An unknown error occurred'), $request['body']);

	}



	return $res;

}

/*END AUTO UDPATE SECTION*/



function sevenfigureteamsystem_redirect_request($request) {

	global $sevenfigureteamsystem_number_of_urls;

	if(!sevenfigureteamsystem_is_activated())

		return $request;



	$uri = (string) $_SERVER['REQUEST_URI'];



	for ($i=1;$i<=$sevenfigureteamsystem_number_of_urls;$i++):

		$sfts_var_name = 'sevenfigureteamsystem_external_url_'.$i;

		$$sfts_var_name = get_option("sevenfigureteamsystem_external_url_".$i, "");

	endfor;

	$sevenfigureteamsystem_first_or_last = get_option("sevenfigureteamsystem_first_or_last", 2);

	$cookie = "";

	if ($sevenfigureteamsystem_first_or_last == 1) {

		//If 1 then first touch

		//First touch cookie instead of last touch cookie - only set cookie if that is not set

		if ( $_COOKIE['sevenfigureteamsystem_cookie'] == '' ) {

			// Check if we have id

			if ( $_GET['uid'] != '' ) {

				$cookie = $_GET['uid'];

			}

		}

	} else {

		//Last touch cookie instead of first touch cookie

		if ( $_GET['uid'] != '' ) {

			$cookie = $_GET['uid'];

		}

	}

	for ($i=1;$i<=$sevenfigureteamsystem_number_of_urls;$i++):

		$sfts_var_name = 'sevenfigureteamsystem_external_url_'.$i;

		if (strpos($uri, "go/".$i) !== false && $$sfts_var_name != "") {

			// Add s1 to the cookie

			if ($cookie != "") setcookie('sevenfigureteamsystem_cookie', $cookie, time()+get_option( 'sevenfigureteamsystem_cookie_time', 31536000 ), '/');

			header ('HTTP/1.1 301 Moved Permanently');

			header ('Location: '.$$sfts_var_name);

			exit;

		}

	endfor;



	// Profile page

	if ( get_option('sevenfigureteamsystem_profile_page') && ($page = get_post(get_option('sevenfigureteamsystem_profile_page'))) ) {

		$uri = (string) $_SERVER['REQUEST_URI'];



		if ( preg_match('%/'.preg_quote($page->post_name).'/([^/]+)/?$%', $uri, $m) ) {

			$user_slug = $m[1];

			$user = get_user_by('login', $user_slug);



			$request = array(

				'page' => '',

				'pagename' => $page->post_name,

				'user_id' => $user->ID,

			);

		}



	}





	return $request;

}

add_filter('request', 'sevenfigureteamsystem_redirect_request');



// WYSIWYG Bio

function sevenfigureteamsystem_profilejs($hook) {

	if ( $hook == 'profile.php' || $hook == 'user-edit.php' ) {

		add_action('admin_footer', 'sevenfigureteamsystem_profilejs_footer');

	}

}

function sevenfigureteamsystem_profilejs_footer() {

	?>

	<script type="text/javascript">

	(function( $ ) {

		// Remove the native textarea before adding the new one

		$( '#description' ).parents( 'tr' ).remove();

	} ) ( jQuery );

	</script>

	<?php

}

add_action( 'admin_enqueue_scripts', 'sevenfigureteamsystem_profilejs' );



function sevenfigureteamsystem_remove_description_filters() {

	remove_all_filters( 'pre_user_description' );

}

add_action('admin_init', 'sevenfigureteamsystem_remove_description_filters');



function sevenfigureteamsystem_wysiwyg_bio($user) {

	if(sevenfigureteamsystem_is_activated()){

		if ( user_can_richedit() ) {

			?>

			<noscript>

				You currently have JavaScript disabled, which is why you're seeing duplicate Biographical Info fields and no WYSIWYG. Please enable JavaScript.

			</noscript>

			<table class="form-table">

				<tr>

					<th><label for="description">Biographical Info</label></th>

					<td>

						<?php

						$description = get_user_meta( $user->ID, 'description', true);

						#$description = apply_filters( 'the_content', $description );

						wp_editor( $description, 'user-description', array(

							'textarea_name' => 'description',

						));

						?>

						<span class="description">Share a little biographical information to fill out your profile. This may be shown publicly.</span>

					</td>

				</tr>

			</table>

		<?php

		}

	}

}

add_action('show_user_profile', 'sevenfigureteamsystem_wysiwyg_bio');

add_action('edit_user_profile', 'sevenfigureteamsystem_wysiwyg_bio');



// Additional fields

function sevenfigureteamsystem_new_contactmethods( $fields ) {

	global $sevenfigureteamsystem_number_of_urls;



	if(!sevenfigureteamsystem_is_activated())

		return $fields;

	for ($i = 1; $i <= $sevenfigureteamsystem_number_of_urls; $i++) {

		$fields['sfts_field_title'.$i] = 'Link Title '.$i;

		$fields['sfts_field_url'.$i] = 'Link URL '.$i;

	}



    return $fields;

}

add_filter('user_contactmethods', 'sevenfigureteamsystem_new_contactmethods');



// Referral when add / edit user

function sevenfigureteamsystem_add_user_form_FE($code = false){

	global $sevenfigureteamsystem_cookie;



	if(!sevenfigureteamsystem_is_activated())

		return "";



	$cookie = $sevenfigureteamsystem_cookie;



	$html = "";

	if($code != "")

		ob_start();

	?>

	<input type="hidden" name="referral" id="referral" value="<?php echo esc_attr(stripslashes($cookie)); ?>" />

	<?php

	if($code != ""){

		$html = ob_get_contents();

		$code = str_replace('</form>', $html .'</form>', $code);

		ob_clean();

		return $code;

	}

}

add_action('register_form','sevenfigureteamsystem_add_user_form_FE', 10, 1);

add_filter('ws_plugin__optimizemember_pro_sc_paypal_form', 'sevenfigureteamsystem_add_user_form_FE', 10, 1);



function sevenfigureteamsystem_add_user_callback_FE($user_id){

	if(!is_admin() && !empty($_POST['referral']) && sevenfigureteamsystem_is_activated()){

		update_user_meta($user_id, 'referral', $_POST['referral']);

	}

	elseif(is_admin() && current_user_can( 'create_users' ) && !empty($_POST['sevenfigureteamsystem_referral']) && sevenfigureteamsystem_is_activated()){

		update_user_meta($user_id, 'referral', $_POST['sevenfigureteamsystem_referral']);

	}

}

add_action( 'user_register', 'sevenfigureteamsystem_add_user_callback_FE' );



function sevenfigureteamsystem_add_user_form_BE(){

	if ( ! current_user_can( 'create_users' ) || !sevenfigureteamsystem_is_activated() )

		return;



	wp_nonce_field( 'sevenfigureteamsystem_user_profile_update', 'sevenfigureteamsystem_nonce' );

	$args = array(

		'show_option_all'         => null, // string

		'show_option_none'        => null, // string

		'hide_if_only_one_author' => null, // string

		'orderby'                 => 'display_name',

		'order'                   => 'ASC',

		'include'                 => null, // string

		'exclude'                 => null, // string

		'multi'                   => false,

		'show'                    => 'display_name',

		'echo'                    => true,

		'selected'                => get_option("sevenfigureteamsystem_default_referrer_be", ""),

		'include_selected'        => false,

		'name'                    => 'sevenfigureteamsystem_referral', // string

		'id'                      => 'sevenfigureteamsystem_referral', // integer

		'class'                   => null, // string

		'blog_id'                 => $GLOBALS['blog_id'],

		'who'                     => null // string

	);

	?>

	<h3 id="sevenfigureteamsystem"><?php _e( '7 Figure Team System', 'sevenfigureteamsystem' ); ?></h3>

	<table class="form-table">

		<tr>

			<th><label for="sevenfigureteamsystem_referral"><?php _e( 'Referrer', 'sevenfigureteamsystem' ); ?></label></th>

			<td><?php wp_dropdown_users( $args ); ?></td>

		</tr>

	</table>

	<br /><br />

	<?php

}

add_action( 'user_new_form', 'sevenfigureteamsystem_add_user_form_BE' );



function sevenfigureteamsystem_update_user_form_BE($user){

	global $sevenfigureteamsystem_number_of_opportunities;



	if ( ! current_user_can( 'edit_users' ) || !sevenfigureteamsystem_is_activated() )

		return;



	wp_nonce_field( 'sevenfigureteamsystem_user_profile_update', 'sevenfigureteamsystem_nonce' );

	$args = array(

		'show_option_all'         => null, // string

		'show_option_none'        => null, // string

		'hide_if_only_one_author' => null, // string

		'orderby'                 => 'display_name',

		'order'                   => 'ASC',

		'include'                 => null, // string

		'exclude'                 => null, // string

		'multi'                   => false,

		'show'                    => 'display_name',

		'echo'                    => true,

		'selected'                => get_the_author_meta( 'referral', $user->ID ),

		'include_selected'        => false,

		'name'                    => 'sevenfigureteamsystem_referral', // string

		'id'                      => 'sevenfigureteamsystem_referral', // integer

		'class'                   => null, // string

		'blog_id'                 => $GLOBALS['blog_id'],

		'who'                     => null // string

	);

	?>

	<h3 id="sevenfigureteamsystem"><?php _e( '7 Figure Team System', 'sevenfigureteamsystem' ); ?></h3>

	<table class="form-table">

		<tr>

			<th><label for="sevenfigureteamsystem_referrals"><?php _e( 'Referrals', 'sevenfigureteamsystem' ); ?></label></th>

			<td>

			<?php

				$referral_users = get_users(array(

					'meta_key'     => 'referral',

					'meta_value'   => $user->ID,

					'meta_compare' => '=',

					'orderby'      => 'ID',

					'order'        => 'ASC'

				));

				if (count($referral_users)) {

					foreach($referral_users as $referral_user) {

						echo sprintf('<a href="%s" target="_blank">%s</a> - ID = %s - %s<br>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name, $referral_user->ID, $referral_user->user_email);

					}

				} else {

					echo "This user has no referrals so far.";

				}

			?></td>

		</tr>

	</table>

	<br /><br />

	<h3 id="sevenfigureteamsystem"><?php _e( 'Affiliate IDs', 'sevenfigureteamsystem' ); ?></h3>

	<table class="form-table">

		<tbody>



			<?php for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) : ?>

			<?php

				$sevenfigureteamsystem_title = get_option( 'sevenfigureteamsystem_title_'. $i, "");

			?>

			<?php if ($sevenfigureteamsystem_title != ""): ?>

			<tr valign="top">

				<th scope="row"><?php echo $i; ?>. <?php echo $sevenfigureteamsystem_title; ?></th>

				<td>

					<p><textarea class="large-text code" id="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>" cols="50" rows="2" name="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>"><?php echo get_user_meta( $user->ID, 'sevenfigureteamsystem_cookie_values_'.$i, true ); ?></textarea></p>

				</td>

			</tr>

			<?php endif; ?>

			<?php endfor; ?>



		</tbody>

	</table>

	<br /><br />

	<?php

}

add_action( 'show_user_profile', 'sevenfigureteamsystem_update_user_form_BE' );

add_action( 'edit_user_profile', 'sevenfigureteamsystem_update_user_form_BE' );



function sevenfigureteamsystem_update_user_callback_BE($user_id){

	global $sevenfigureteamsystem_number_of_opportunities;



	if(is_admin() && current_user_can( 'edit_users' ) && sevenfigureteamsystem_is_activated()){

		$referral = $_POST['sevenfigureteamsystem_referral'];

		update_user_meta( $user_id, 'referral', $referral );



		for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) {

			update_user_meta( $user_id, 'sevenfigureteamsystem_cookie_values_'.$i, $_POST['sevenfigureteamsystem_cookie_values_'.$i] );

		}

	}

}

add_action( 'personal_options_update', 'sevenfigureteamsystem_update_user_callback_BE' );

add_action( 'edit_user_profile_update', 'sevenfigureteamsystem_update_user_callback_BE' );



/*

//Add referral from cookie

add_action('register_form','sevenfigureteamsystem_register_form');

//Add referral to add new form

add_action('user_new_form','sevenfigureteamsystem_register_form', 10, 1);

// For OptimizeMember plugin

add_filter('ws_plugin__optimizemember_pro_sc_paypal_form', 'sevenfigureteamsystem_register_form', 10, 1);

function sevenfigureteamsystem_register_form ($code = false){

	if(!sevenfigureteamsystem_is_activated())

		return "";

		global $sevenfigureteamsystem_cookie;



		$cookie = $sevenfigureteamsystem_cookie;

		//if adding new user from BE -> get again referral

		if($code == "add-new-user" || $code == "add-existing-user")

			$cookie = get_sevenfigureteamsystem_default_cookie(true);

//$uidcookie = ( isset( $_COOKIE['sevenfigureteamsystem_cookie'] ) ) ? $_COOKIE['sevenfigureteamsystem_cookie']: '';



if ($code != "add-new-user" && $code != "add-existing-user" && $code != false) :

ob_start();

endif;

?>

<input type="hidden" name="referral" id="referral" value="<?php echo esc_attr(stripslashes($cookie)); ?>" />

<?php

if ($code != "add-new-user" && $code != "add-existing-user" && $code != false) :

$content = ob_get_contents();

$code = str_replace('</form>', $content .'</form>', $code);

ob_clean();

return $code;

endif;

}



//Save referral user meta.

add_action('user_register', 'sevenfigureteamsystem_user_register');

function sevenfigureteamsystem_user_register ($user_id) {

if ( isset( $_POST['referral'] ) )

	update_user_meta($user_id, 'referral', $_POST['referral']);

}



function sevenfigureteamsystem_user_profile( $user ) {

	global $sevenfigureteamsystem_number_of_opportunities;



	if ( ! current_user_can( 'edit_users' ) || !sevenfigureteamsystem_is_activated() )

		return;



	wp_nonce_field( 'sevenfigureteamsystem_user_profile_update', 'sevenfigureteamsystem_nonce' );

	$args = array(

		'show_option_all'         => null, // string

		'show_option_none'        => null, // string

		'hide_if_only_one_author' => null, // string

		'orderby'                 => 'display_name',

		'order'                   => 'ASC',

		'include'                 => null, // string

		'exclude'                 => null, // string

		'multi'                   => false,

		'show'                    => 'display_name',

		'echo'                    => true,

		'selected'                => get_the_author_meta( 'referral', $user->ID ),

		'include_selected'        => false,

		'name'                    => 'sevenfigureteamsystem_referral', // string

		'id'                      => 'sevenfigureteamsystem_referral', // integer

		'class'                   => null, // string

		'blog_id'                 => $GLOBALS['blog_id'],

		'who'                     => null // string

	);

	?>

	<h3 id="sevenfigureteamsystem"><?php _e( '7 Figure Team System', 'sevenfigureteamsystem' ); ?></h3>

	<table class="form-table">

		<tr>

			<th><label for="sevenfigureteamsystem_referral"><?php _e( 'Referrer', 'sevenfigureteamsystem' ); ?></label></th>

			<td><?php wp_dropdown_users( $args ); ?></td>

		</tr>

		<tr>

			<th><label for="sevenfigureteamsystem_referrals"><?php _e( 'Referrals', 'sevenfigureteamsystem' ); ?></label></th>

			<td>

			<?php

				$referral_users = get_users(array(

					'meta_key'     => 'referral',

					'meta_value'   => $user->ID,

					'meta_compare' => '=',

					'orderby'      => 'ID',

					'order'        => 'ASC'

				));

				if (count($referral_users)) {

					foreach($referral_users as $referral_user) {

						echo sprintf('<a href="%s" target="_blank">%s</a> - ID = %s - %s<br>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name, $referral_user->ID, $referral_user->user_email);

					}

				} else {

					echo "This user has no referrals so far.";

				}

			?></td>

		</tr>

	</table>

	<br /><br />

	<h3 id="sevenfigureteamsystem"><?php _e( 'Affiliate IDs', 'sevenfigureteamsystem' ); ?></h3>

	<table class="form-table">

		<tbody>



			<?php for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) : ?>

			<?php

				$sevenfigureteamsystem_title = get_option( 'sevenfigureteamsystem_title_'. $i, "");

			?>

			<?php if ($sevenfigureteamsystem_title != ""): ?>

			<tr valign="top">

				<th scope="row"><?php echo $i; ?>. <?php echo $sevenfigureteamsystem_title; ?></th>

				<td>

					<p><textarea class="large-text code" id="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>" cols="50" rows="2" name="sevenfigureteamsystem_cookie_values_<?php echo $i; ?>"><?php echo get_user_meta( $user->ID, 'sevenfigureteamsystem_cookie_values_'.$i, true ); ?></textarea></p>

				</td>

			</tr>

			<?php endif; ?>

			<?php endfor; ?>



		</tbody>

	</table>

	<br /><br />

<?php

}



function sevenfigureteamsystem_user_new_profile( ) {



	if ( ! current_user_can( 'create_users' ) || !sevenfigureteamsystem_is_activated() )

		return;



	wp_nonce_field( 'sevenfigureteamsystem_user_profile_update', 'sevenfigureteamsystem_nonce' );

	$args = array(

		'show_option_all'         => null, // string

		'show_option_none'        => null, // string

		'hide_if_only_one_author' => null, // string

		'orderby'                 => 'display_name',

		'order'                   => 'ASC',

		'include'                 => null, // string

		'exclude'                 => null, // string

		'multi'                   => false,

		'show'                    => 'display_name',

		'echo'                    => true,

		'selected'                => get_option("sevenfigureteamsystem_default_referrer_be", ""),

		'include_selected'        => false,

		'name'                    => 'sevenfigureteamsystem_referral', // string

		'id'                      => 'sevenfigureteamsystem_referral', // integer

		'class'                   => null, // string

		'blog_id'                 => $GLOBALS['blog_id'],

		'who'                     => null // string

	);

	?>

	<h3 id="sevenfigureteamsystem"><?php _e( '7 Figure Team System', 'sevenfigureteamsystem' ); ?></h3>

	<table class="form-table">

		<tr>

			<th><label for="sevenfigureteamsystem_referral"><?php _e( 'Referrer', 'sevenfigureteamsystem' ); ?></label></th>

			<td><?php wp_dropdown_users( $args ); ?></td>

		</tr>

	</table>

	<br /><br />

<?php

}



function sevenfigureteamsystem_user_profile_update( $user_id ) {

	global $sevenfigureteamsystem_number_of_opportunities;



	if(is_admin()){

		$referral = isset( $_POST['sevenfigureteamsystem_referral'] ) ? $_POST['sevenfigureteamsystem_referral'] : get_option("sevenfigureteamsystem_default_referrer_be", "");

		update_user_meta( $user_id, 'referral', $referral );



		for($i=1;$i<=$sevenfigureteamsystem_number_of_opportunities;$i++) {

			update_user_meta( $user_id, 'sevenfigureteamsystem_cookie_values_'.$i, $_POST['sevenfigureteamsystem_cookie_values_'.$i] );

		}

	}

}



add_action( 'show_user_profile', 'sevenfigureteamsystem_user_profile' );

add_action( 'edit_user_profile', 'sevenfigureteamsystem_user_profile' );

add_action( 'user_new_form', 'sevenfigureteamsystem_user_new_profile' );

add_action( 'personal_options_update', 'sevenfigureteamsystem_user_profile_update' );

add_action( 'edit_user_profile_update', 'sevenfigureteamsystem_user_profile_update' );

add_action( 'user_register', 'sevenfigureteamsystem_user_profile_update' );*/



function sevenfigureteamsystem_query_vars($vars) {

	if(!sevenfigureteamsystem_is_activated())

		return $vars;

	$vars[] = 'user_id';

	return $vars;

}

add_filter('query_vars', 'sevenfigureteamsystem_query_vars');



function sevenfigureteamsystem_profile_url($user_id) {

	$page_id = get_option('sevenfigureteamsystem_profile_page');

	if ( $page_id && sevenfigureteamsystem_is_activated() ) {

		$user = get_userdata($user_id);



		$permalink = get_option('permalink_structure');



		if ( '' != $permalink ) {

			return bp_core_get_user_domain($user_id);

		} else {

			return add_query_arg(array('user_id' => $user->ID), get_permalink($page_id));

		}

	}



	return false;

}



// Customize Profile Page

function sevenfigureteamsystem_handle_profile_page() {

	add_filter('wp_title', 'sevenfigureteamsystem_profile_title');

	//Support WordPress SEO - Yoast

	add_filter('wpseo_title', 'sevenfigureteamsystem_profile_title');

	//Support AIO Seo Pack

	add_filter('aioseop_title', 'sevenfigureteamsystem_profile_title');

	add_filter('the_title', 'sevenfigureteamsystem_profile_title');

	add_filter('single_post_title', 'sevenfigureteamsystem_profile_title');

	add_filter('the_content', 'sevenfigureteamsystem_profile_content');

}



add_action('template_redirect', 'sevenfigureteamsystem_handle_profile_page');



function sevenfigureteamsystem_profile_title($title) {

	if ( is_page(get_option('sevenfigureteamsystem_profile_page')) && sevenfigureteamsystem_is_activated() ) {

		global $wp_query;



		$q = $wp_query->query_vars;



		if ( !empty($q['user_id']) ) {

			$user = new WP_User($q['user_id']);



			return str_replace('{user_name}', $user->display_name, $title);

		} else {

			return str_replace('{user_name}', "", $title);

		}

	} else {

		return $title;

	}

}



function sevenfigureteamsystem_profile_content($content) {

	global $wp_query;

	global $sevenfigureteamsystem_number_of_urls;



	$q = $wp_query->query_vars;



	$output = $content;



	if ( !empty($q['user_id']) && sevenfigureteamsystem_is_activated() ) {

		$user = new WP_User($q['user_id']);



		$extra_fields = '';



		//Print out avatar of user in profile - before content

		$avatar_output = "";

		$avatar_output .= '<div class="sevenfigure-user-avatar">';

		$avatar_output .= get_avatar( $user->ID );

		$avatar_output .= '</div>';

		$output = $avatar_output.$output;



		//Print out links if any

		for ( $i = 1; $i <= $sevenfigureteamsystem_number_of_urls; $i++ ) {

			$title = get_user_meta($user->ID, 'sfts_field_title'.$i, true);

			$url = get_user_meta($user->ID, 'sfts_field_url'.$i, true);



			if ( $title && $url ) {

				$extra_fields .= sprintf('<li><a href="%s">%s</a>', $url, $title);

			}

		}



		if ( !empty($extra_fields) ) {

			$output .= sprintf('<ul class="sevenfigure-extra-profile-fields">%s</ul>', $extra_fields);

		}



		//Print out bio if set in back end

		if ( get_user_meta($user->ID, 'description', true) ) {

			$output .= '<div class="sevenfigure-user-description">';

			$output .= wpautop(get_user_meta($user->ID, 'description', true));

			$output .= '</div>';

		}

	}



	return $output;

}



function sevenfigureteamsystem_profile_shortcode( $atts ) {

	if(!sevenfigureteamsystem_is_activated())

		return "";

	$current_user = wp_get_current_user();

	if ( $current_user->ID == 0) {

		// Not logged in, check cookie

		if ( isset($_COOKIE['sevenfigureteamsystem_cookie']) && !isset($_GET['uid']) ) {

			$user_id_referral = $_COOKIE['sevenfigureteamsystem_cookie'];

		} else {

			global $sevenfigureteamsystem_cookie;

			$user_id_referral = $sevenfigureteamsystem_cookie;

		}

	} else {

		$user_id_referral = get_user_meta($current_user->ID, 'referral', true);

	}

	if ( $user_id_referral == '') {

		//Don't have referral

		//Return for uid=1

		$user_id_referral = 1;

	}

	$referral_user = get_user_by('id', $user_id_referral);

	return sevenfigureteamsystem_profile_url($user->ID) ? sprintf('<a href="%s" target="_blank">%s</a>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name) : sprintf('%s', $referral_user->display_name);

}

add_shortcode( '7figure-referrer', 'sevenfigureteamsystem_profile_shortcode' );



function sevenfigureteamsystem_profile_shortcode_justname( $atts ) {

	if(!sevenfigureteamsystem_is_activated())

		return "";

	$current_user = wp_get_current_user();

	if ( $current_user->ID == 0) {

		// Not logged in, check cookie

		if ( isset($_COOKIE['sevenfigureteamsystem_cookie']) && !isset($_GET['uid']) ) {

			$user_id_referral = $_COOKIE['sevenfigureteamsystem_cookie'];

		} else {

			global $sevenfigureteamsystem_cookie;

			$user_id_referral = $sevenfigureteamsystem_cookie;

		}

	} else {

		$user_id_referral = get_user_meta($current_user->ID, 'referral', true);

	}

	if ( $user_id_referral == '') {

		//Don't have referral

		//Return for uid=1

		$user_id_referral = 1;

	}

	$referral_user = get_user_by('id', $user_id_referral);

	return $referral_user->display_name;

}

add_shortcode( '7figure-referrer-name', 'sevenfigureteamsystem_profile_shortcode_justname' );



function sevenfigureteamsystem_profile_link( $atts ) {

	if(!sevenfigureteamsystem_is_activated())

		return "";



	$default = array('id' => false);

	$atts = shortcode_atts($default, $atts);



	$current_user = wp_get_current_user();

	if ( $current_user->ID == 0) {

		// Not logged in, check cookie

		if ( isset($_COOKIE['sevenfigureteamsystem_cookie']) && !isset($_GET['uid']) ) {

			$user_id_referral = $_COOKIE['sevenfigureteamsystem_cookie'];

		} else {

			global $sevenfigureteamsystem_cookie;

			$user_id_referral = $sevenfigureteamsystem_cookie;

		}

	} else {

		$user_id_referral = get_user_meta($current_user->ID, 'referral', true);

	}

	if ( $user_id_referral == '') {

		//Don't have referral

		//Return for uid=1

		$user_id_referral = 1;

	}



	$title = get_user_meta($user_id_referral, 'sfts_field_title'.$atts['id'], true);

	$url = get_user_meta($user_id_referral, 'sfts_field_url'.$atts['id'], true);



	if(!empty($title) && !empty($url)){

		return "<a href='$url' target='_blank'>$title</a>";

	}

	else{

		return "";

	}

}

add_shortcode( '7figure-profile-link', 'sevenfigureteamsystem_profile_link' );



class WP_7_Figure_Team_System extends WP_Widget {



	function __construct() {

		$widget_ops = array('classname' => '7_figure_team_system', 'description' => __( '7-Figure Team System referred user widget.') );

		parent::__construct('7_figure_team_system', __('7-Figure referred user'), $widget_ops);

	}



	function widget( $args, $instance ) {

		extract( $args );



		// For test

		// update_user_meta(2, 'referral', 1);



		$current_user = wp_get_current_user();

		if ( $current_user->ID == 0) {

			// Not logged in, check cookie

			if ( isset($_COOKIE['sevenfigureteamsystem_cookie']) && !isset($_GET['uid']) ) {

				$user_id_referral = $_COOKIE['sevenfigureteamsystem_cookie'];

			} else {

				global $sevenfigureteamsystem_cookie;

				$user_id_referral = $sevenfigureteamsystem_cookie;

			}

		} else {

			$user_id_referral = get_user_meta($current_user->ID, 'referral', true);

		}

		if ( $user_id_referral == '') {

			// Don't have referral

			//Return for uid=1

			$user_id_referral = 1;

		}

		$referral_user = get_user_by('id', $user_id_referral);



    echo $before_widget;

		if ( ! empty( $instance['title'] ) ) {

			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];

		}

		?>

<p>You were referred to <?php print get_bloginfo('name'); ?> by <strong><?php echo sevenfigureteamsystem_profile_url($referral_user->ID) ? sprintf('<a href="%s">%s</a>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name) : sprintf('%s', $referral_user->display_name); ?></strong></p>

		<?php

		echo get_avatar( $user_id_referral );

    echo $after_widget;

	}



	function form( $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : '7-Figure Referrer';

		?>

		<p>

		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>

		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">

		</p>

		<?php

	}



	function update( $new_instance, $old_instance ) {

		$instance = array();

		$instance['title'] = strip_tags( $new_instance['title'] );



		return $instance;

	}



}



function seven_figure_team_system_widgets_register() {

	if ( !is_blog_installed() || !sevenfigureteamsystem_is_activated() ) {

		return;

	}

	register_widget('WP_7_Figure_Team_System');

}

add_action('widgets_init', 'seven_figure_team_system_widgets_register', 1);



function seven_figure_team_system_referral_column( $defaults ) {

	//$defaults['seven_figure_team_system_referral_column'] = 'Referrer';

	$defaults['seven_figure_team_system_referrals_column'] = 'Referrals';

	return $defaults;

}



function seven_figure_team_system_custom_referral_column($value, $column_name, $id) {

	if( $column_name == 'seven_figure_team_system_referral_column' ) {

		$user_id_referral = get_the_author_meta( 'referral', $id );

		$referral_user = get_user_by('id', $user_id_referral);

		if ($referral_user->ID) {

			return sprintf('<a href="%s">%s</a>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name);

		} else {

			return "";

		}

	} elseif ($column_name == 'seven_figure_team_system_referrals_column') {

		$referral_users = get_users(array(

			'meta_key'     => 'referral',

			'meta_value'   => $id,

			'meta_compare' => '=',

			'orderby'      => 'display_name',

			'order'        => 'ASC'

		));

		$referrals_data = "";

		if (count($referral_users)) {

			foreach($referral_users as $referral_user) {

				$referrals_data .= sprintf('<a href="%s" target="_blank">%s</a><br>', sevenfigureteamsystem_profile_url($referral_user->ID), $referral_user->display_name);

			}

			return $referrals_data;

		} else {

			return "No referrals";

		}

	} else {

		return $value;

	}

}

add_action('manage_users_custom_column', 'seven_figure_team_system_custom_referral_column', 15, 3);

add_filter('manage_users_columns', 'seven_figure_team_system_referral_column', 15, 1);