<?php

function seven_figure_team_system_init_infusionsoft()
{
	$infusionSoftClientApp = get_option( 'sevenfigureteamsystem_infusionsoft_app', array(
		'client_id' => '',
		'client_secret' => '',
	) );

	$infusionsoft = null;

	if ( !empty( $infusionSoftClientApp['client_id'] ) && !empty( $infusionSoftClientApp['client_secret'] ) ) {
		$redirectUri = home_url( '/wp-admin/options-general.php?page=sevenfigureteamsystem_infusionsoft_form' );

		$infusionsoft = new \Infusionsoft\Infusionsoft(array(
			'clientId'     => $infusionSoftClientApp['client_id'],
			'clientSecret' => $infusionSoftClientApp['client_secret'],
			'redirectUri'  => $redirectUri,
		));
	}

	return $infusionsoft;
}

function seven_figure_team_system_setup_infusionsoft_access_token()
{
	$infusionsoft = seven_figure_team_system_init_infusionsoft();
	$infusionSoftToken = get_option( 'sevenfigureteamsystem_infusionsoft_token', array() );

	if ( empty( $infusionSoftToken ) ) {
		return false;
	}

	$end = $infusionSoftToken->endOfLife;
    $current = time();
    
    try {
        $infusionsoft->setToken( $infusionSoftToken );
        if ( $current - $end >= 0 ) {
            $infusionsoft->refreshAccessToken();
            $infusionSoftToken = $infusionsoft->getToken();

            update_option( 'sevenfigureteamsystem_infusionsoft_token', $infusionSoftToken );
        }
    } catch ( Exception $e ) {
        $errorMsg = $e->getMessage();
        seven_figure_team_system_trigger_infusionsoft_error( $errorMsg );

        return false;
    }

	return $infusionsoft;
}

function seven_figure_team_system_infusionsoft_get_affiliate_id_of_contact( $infusionsoft, $contactId )
{
    $result = array(
        'status' => 'ok',
        'id' => '',
    );

    if ( empty( $infusionsoft ) || empty( $contactId ) ) {
        return $result;
    }

    try {
        $data = $infusionsoft->data()->query('Referral', 1, 0, array(
            'ContactId' => $contactId
        ), array( 'AffiliateId' ), 'Id', false);
        if ( !empty( $data ) && !empty( $data[0]['AffiliateId'] ) ) {
            $result['id'] = $data[0]['AffiliateId'];
        }
    } catch ( Exception $e ) {
        $errorMsg = $e->getMessage();
        seven_figure_team_system_trigger_infusionsoft_error( $errorMsg );

        $result['status'] = 'error';
    }

    return $result;
}

function seven_figure_team_system_infusionsoft_get_affiliate_email_from_id( $infusionsoft, $affiliateId )
{
    $result = array(
        'status' => 'ok',
        'email' => '',
    );

    if ( empty( $infusionsoft ) || empty( $affiliateId ) ) {
        return $result;
    }

    try {
        $data = $infusionsoft->data()->findByField('Affiliate', 1, 0, 'Id', $affiliateId, array( 'ContactId' ));
        if ( !empty( $data ) && !empty( $data[0]['ContactId'] ) ) {
            $contactId = $data[0]['ContactId'];

            $data = $infusionsoft->data()->findByField('Contact', 1, 0, 'Id', $contactId, ['Email']);
            if ( !empty( $data ) && !empty( $data[0]['Email'] ) ) {
                $result['email'] = $data[0]['Email'];
            }
        }
    } catch ( Exception $e ) {
        $errorMsg = $e->getMessage();
        seven_figure_team_system_trigger_infusionsoft_error( $errorMsg );

        $result['status'] = 'error';
    }

    return $result;
}

function seven_figure_team_system_trigger_infusionsoft_error( $error )
{
    seven_figure_team_system_warning_infusionsoft_error( $error );
    seven_figure_team_system_force_stop_infusionsoft_schedule();

    return true;
}

function seven_figure_team_system_warning_infusionsoft_error( $error )
{
    $sentWarning = get_option( 'sevenfigureteamsystem_infusionsoft_sent_warning_error', 0 );
    if ( !$sentWarning && !empty( $error ) ) {
        $adminEmail = get_bloginfo( 'admin_email' );
        if ( !empty( $adminEmail ) ) {
            $subject = "7figureteamsystem infusionsoft intergrate error";
            $content = "Error: {$error}";

            wp_mail( $adminEmail, $subject, $content );
            update_option( 'sevenfigureteamsystem_infusionsoft_sent_warning_error', 1 );
        }
    }

    return true;
}

function seven_figure_team_system_force_stop_infusionsoft_schedule()
{
    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_stop', 1 );

    return true;
}

function seven_figure_team_system_reset_infusionsoft_tracking_option()
{
    update_option( 'sevenfigureteamsystem_infusionsoft_sent_warning_error', 0 );
    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_stop', 0 );
    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 0 );

    return true;
}

function seven_figure_team_system_infusionsoft_generate_rest_http_link( $rest )
{
    $requestRestVar = '_sevenfigureteamsystem_infusionsoft_rest';

    return add_query_arg( array(
        $requestRestVar => $rest,
    ), home_url() );
}

function seven_figure_team_system_infusionsoft_parse_rest_http_link()
{
    $requestRestVar = '_sevenfigureteamsystem_infusionsoft_rest';

    return !empty( $_GET[$requestRestVar] ) ? $_GET[$requestRestVar] : '';
}