<?php

require_once 'vendor/autoload.php';
require_once 'helpers.php';
require_once 'update-referrer-scheduler.php';

add_action('admin_menu', 'sevenfigureteamsystem_infusionsoft_setup_menu', 99);
function sevenfigureteamsystem_infusionsoft_setup_menu()
{
    if( sevenfigureteamsystem_is_activated() ) {
        add_options_page( '7-Figure Team Infusionsoft Config', '7-Figure Team Infusionsoft Config', 'manage_options', 'sevenfigureteamsystem_infusionsoft_form', 'sevenfigureteamsystem_infusionsoft_form');
    }
}

function sevenfigureteamsystem_infusionsoft_form() {


	if ( isset($_POST['sevenfigureteamsystem_update']) ) {

        if ( !empty( $_POST['infusionsoft_app'] ) ) {
            update_option( 'sevenfigureteamsystem_infusionsoft_app', $_POST['infusionsoft_app']);
        }
        
        update_option( 'sevenfigureteamsystem_infusionsoft_schedule_stop', $_POST['sevenfigureteamsystem_infusionsoft_schedule_stop']);

		echo '<div class="updated"><p><strong>Settings saved.</strong></p></div>';

    }
    
    if ( isset($_POST['sevenfigureteamsystem_reset_tracking']) ) {

		seven_figure_team_system_reset_infusionsoft_tracking_option();

		echo '<div class="updated"><p><strong>Reset done.</strong></p></div>';

	}

	$infusionSoftClientApp = get_option( 'sevenfigureteamsystem_infusionsoft_app', array(
		'client_id' => '',
		'client_secret' => '',
	) );
	$infusionSoftToken = get_option( 'sevenfigureteamsystem_infusionsoft_token', array() );

	$infusionsoft = seven_figure_team_system_init_infusionsoft();
	if ( !empty( $infusionsoft ) ) {
		if ( isset( $_GET['code'] ) && empty( $infusionSoftToken ) ) {
            try {
                $infusionSoftToken = $infusionsoft->requestAccessToken( $_GET['code'] );
			    update_option( 'sevenfigureteamsystem_infusionsoft_token', $infusionSoftToken );
            } catch ( Exception $e ) {
                $errorMsg = $e->getMessage();
                seven_figure_team_system_trigger_infusionsoft_error( $errorMsg );
            }
		}
    }
    
    $scheduleRunning = get_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 0 );
    $scheduleRunning = $scheduleRunning ? 'Yes' : 'No';

    $scheduleStatus = $scheduleStop = get_option( 'sevenfigureteamsystem_infusionsoft_schedule_stop', 0 );
    $scheduleStatus = $scheduleStatus ? 'Yes' : 'No';

	?>

	<div class="wrap">

		<h2>7-Figure Team Infusionsoft Config</h2>

		<form action="" method="post" class="form-update-settings">

			<table class="form-table">

				<tbody>

					<tr>

						<th colspan="2">App Config</th>

					</tr>

					<tr valign="top">

						<th scope="row">Client ID</th>

						<td>

							<p><input type="text" value="<?php echo $infusionSoftClientApp['client_id']; ?>" id="sevenfigureteamsystem_infusionsoft_client_id" name="infusionsoft_app[client_id]" /></p>

						</td>

					</tr>

					<tr valign="top">

						<th scope="row">Client Secret</th>

						<td>

							<p><input type="text" value="<?php echo $infusionSoftClientApp['client_secret']; ?>" id="sevenfigureteamsystem_infusionsoft_client_secret" name="infusionsoft_app[client_secret]" /></p>

						</td>

					</tr>

					<tr>

						<th scope="row">Token</th>

						<td>

							<?php
							if ( !empty( $infusionSoftToken ) ) :
							?>
						
							<pre>

								<?php var_dump( $infusionSoftToken ); ?>

							</pre>

							<?php
							elseif ( !empty( $infusionsoft ) ) :
								echo '<a href="' . $infusionsoft->getAuthorizationUrl() . '">Click here to authorize</a>';
							endif;
							?>

						</td>

					</tr>

                    <tr>

						<th colspan="2">Schedule config</th>

					</tr>

                    <tr valign="top">

						<th scope="row">Stop queue schedule</th>

						<td>

							<p>

                                <select name="sevenfigureteamsystem_infusionsoft_schedule_stop">

                                    <option value="0"<?php echo $scheduleStop ? '' : ' selected="selected"' ?>>No</option>
                                    <option value="1"<?php echo $scheduleStop ? ' selected="selected"' : '' ?>>Yes</option>

                                </select>
                            
                            </p>

						</td>

					</tr>

                    <tr>

						<th colspan="2">Schedule tracking status</th>

					</tr>

                    <tr valign="top">

						<th scope="row">Running</th>

						<td>

							<?php echo $scheduleRunning ?>

						</td>

					</tr>

                    <tr valign="top">

						<th scope="row">Force stop</th>

						<td>

							<?php echo $scheduleStatus ?>

						</td>

					</tr>

				</tbody>

			</table>

			<p class="submit">
                <input type="submit" value="Save" class="button button-primary" id="sevenfigureteamsystem_update" name="sevenfigureteamsystem_update" />&nbsp;&nbsp;
                <input type="submit" value="Reset schedule tracking" class="button button-primary" id="sevenfigureteamsystem_reset_tracking" name="sevenfigureteamsystem_reset_tracking" />
            </p>

		</form>

	</div>

<?php

}

add_action( 'user_register', 'sevenfigureteamsystem_infusionsoft_move_new_user_to_queue', 99, 1 );
function sevenfigureteamsystem_infusionsoft_move_new_user_to_queue( $user_id )
{
    if ( !empty( $user_id ) ) {
        $scheduler = UpdateReferrerScheduler::getInstance();
        $scheduler->addToQueue( $user_id );
    }
}

add_action( 'init', 'sevenfigureteamsystem_infusionsoft_handle_rest_http', 99 );
function sevenfigureteamsystem_infusionsoft_handle_rest_http()
{
    $httpRest = seven_figure_team_system_infusionsoft_parse_rest_http_link();
    if ( !empty( $httpRest ) ) {
        $funcCall = "sevenfigureteamsystem_infusionsoft_rest_{$httpRest}";
        if ( function_exists( $funcCall ) ) {
            $params = array();
            if ( $httpRest == 'run_schedule' ) {
                $params = array_merge( $params, array( 'http_rest' ) );
            }
            
            call_user_func_array( $funcCall, $params );
        }

        exit;
    }
}

function sevenfigureteamsystem_infusionsoft_rest_test()
{
    echo 'Test';
}

function sevenfigureteamsystem_infusionsoft_rest_run_schedule( $env )
{
    $scheduleRunning = get_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 0 );
    $scheduleStatus = get_option( 'sevenfigureteamsystem_infusionsoft_schedule_stop', 0 );

    if ( $scheduleRunning ) {
        echo 'Scheduler is running.';
        return;
    }

    if ( $scheduleStatus ) {
        echo 'Scheduler force stopped.';
        return;
    }

    $scheduler = UpdateReferrerScheduler::getInstance();
    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 1 );

    $scheduler->processQueue();

    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 0 );

    echo 'Done';
}

function sevenfigureteamsystem_infusionsoft_rest_run_manually()
{
    $scheduleRunning = get_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 0 );
    $user = !empty( $_GET['user'] ) ? $_GET['user'] : '';

    if ( $scheduleRunning ) {
        echo 'Scheduler is running.';
        return;
    }

    if ( empty( $user ) ) {
        echo 'Need user id.';
        return;
    }

    $infusionsoft = seven_figure_team_system_setup_infusionsoft_access_token();
    if ( empty( $infusionsoft ) ) {
        echo 'Infusionsoft init failed.';
        return;
    }

    $scheduler = UpdateReferrerScheduler::getInstance();
    $mapAffiliates = get_option( 'sevenfigureteamsystem_infusionsoft_map_affiliates', array() );
    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 1 );

    $result = $scheduler->processWpUser( $infusionsoft, $user, $mapAffiliates );

    echo "<pre>";

    var_dump( $result );

    echo "</pre>";

    $mapAffiliates = $result['map_affiliates'];
    update_option( 'sevenfigureteamsystem_infusionsoft_map_affiliates', $mapAffiliates );

    update_option( 'sevenfigureteamsystem_infusionsoft_schedule_running', 0 );

    echo 'Done';
}

add_filter( 'cron_schedules', 'sevenfigureteamsystem_infusionsoft_schedule_add_cron_interval' );
function sevenfigureteamsystem_infusionsoft_schedule_add_cron_interval( $schedules ) {
    $schedules['every_5_minutes'] = array(
            'interval'  => 5 * 60, // time in seconds
            'display'   => 'Every 5 Minutes',
    );
    return $schedules;
}

add_action( 'sevenfigureteamsystem_infusionsoft_schedule_process_queue', 'sevenfigureteamsystem_infusionsoft_schedule_process_queue' );
function sevenfigureteamsystem_infusionsoft_schedule_process_queue()
{
    sevenfigureteamsystem_infusionsoft_rest_run_schedule( 'wp_schedule' );
}