<?php

class UpdateReferrerScheduler
{
    private static $_instance = null;

    private $_tableScheduler;

    private $_wpdb;

    private $_limitProcessQueue = 5;

    private function __construct()
    {
        global $wpdb;

        $this->_wpdb = $wpdb;
        $this->_tableScheduler = $this->_wpdb->prefix . '7figureteamsystem_infusionsoft_schedule_update_referrer';

        $this->_initTable();
    }

    public static function getInstance()
    {
        if ( self::$_instance == null ) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    public function addToQueue( $userId )
    {
        if ( empty( $userId ) ) {
            return false;
        }

        return $this->_wpdb->insert(
            $this->_tableScheduler,
            array(
                'user_id' => $userId
            ),
            array( '%d' )
        );
    }

    public function processQueue()
    {
        $offset = 0;
        $limit = $this->_limitProcessQueue;
        $infusionsoft = seven_figure_team_system_setup_infusionsoft_access_token();

        if ( empty( $infusionsoft ) ) {
            return false;
        }

        $sqlGet = $this->_wpdb->prepare(
            "SELECT `id`, `user_id`, `result` FROM {$this->_tableScheduler} WHERE `processed` = %d LIMIT %d, %d",
            -1,
            $offset,
            $limit
        );
        $mapAffiliates = get_option( 'sevenfigureteamsystem_infusionsoft_map_affiliates', array() );
        $queues = $this->_wpdb->get_results( $sqlGet );

        if ( !empty( $queues ) ) {
            foreach ( $queues as $queue ) {
                $prevProcessResult = !empty( $queue->result ) ? $queue->result : '';
                $result = $this->processWpUser( $infusionsoft, $queue->user_id, $mapAffiliates, $prevProcessResult );
                $mapAffiliates = $result['map_affiliates'];

                if ( $result['stop_schedule'] ) {
                    break;
                }
            }
        }

        update_option( 'sevenfigureteamsystem_infusionsoft_map_affiliates', $mapAffiliates );

        return true;
    }

    public function processWpUser( $infusionsoft, $userId, $mapAffiliates, $prevProcessResult = false )
    {
        $result = array(
            'logs' => '',
            'map_affiliates' => array(),
            'stop_schedule' => false,
        );
        
        if ( $prevProcessResult === false ) {
            $queue = $this->_getQueueByUser( $userId );
            $prevProcessResult = !empty( $queue['result'] ) ? $queue['result'] : '';
        }

        $logs = !empty( $prevProcessResult ) ? maybe_unserialize( $prevProcessResult ) : array();
        $defaultReferrer = get_option('sevenfigureteamsystem_default_referrer_be', '');
        $newLog = array();
        $needSetDefaultReferer = false;

        $newLog[] = 'Check wp user referrer';
        $referrer = get_user_meta( $userId, 'referral', true );
        if ( empty( $referrer ) ) {
            $newLog[] = "Not set referer";
            $newLog[] = 'Check infusion contact id';
            $contactId = get_user_meta( $userId, 'infusionsoft_user_id', true );

            if ( !empty( $contactId ) ) {
                $newLog[] = "Found {$contactId}";
                $newLog[] = "Get affiliate id from contact id";
                $affiliate = seven_figure_team_system_infusionsoft_get_affiliate_id_of_contact( $infusionsoft, $contactId );
                $affiliateId = 0;
                
                if ( !empty( $affiliate['id'] ) ) {
                    $affiliateId = $affiliate['id'];
                    $newLog[] = "Found affiliate id {$affiliateId}";
                } else {
                    $newLog[] = "Not found";
                }

                if ( $affiliate['status'] == 'ok' ) {
                    if ( !empty( $affiliateId ) ) {
                        $newLog[] = "Find affiliate email from map affiliates";
                        $affiliateEmail = !empty( $mapAffiliates[$affiliateId] ) ? $mapAffiliates[$affiliateId] : '';

                        if ( empty( $affiliateEmail ) ) {
                            $newLog[] = "Not found";
                            $newLog[] = "Get affiliate email from affiliate id";
                            $affiliate = seven_figure_team_system_infusionsoft_get_affiliate_email_from_id( $infusionsoft, $affiliate['id'] );
                        
                            if ( !empty( $affiliate['email'] ) ) {
                                $affiliateEmail = $affiliate['email'];
                                $mapAffiliates[$affiliateId] = $affiliateEmail;
                                $newLog[] = "Found affiliate email {$affiliate['email']}";
                            } else {
                                $newLog[] = "Not found";
                            }

                            if ( $affiliate['status'] != 'ok' ) {
                                $result['stop_schedule'] = true;
                                $newLog[] = "Infusionsoft api failed";
                            }
                        } else {
                            $newLog[] = "Found affiliate email {$affiliateEmail}";
                        }

                        if ( !empty( $affiliateEmail ) ) {
                            $newLog[] = "Get wp user from affiliate email";
                            $affiliateWpUser = get_user_by( 'email', $affiliateEmail );

                            if ( !empty( $affiliateWpUser ) ) {
                                $newLog[] = "Found wp user {$affiliateWpUser->ID}";
                                $affiliateWpUser = $affiliateWpUser->ID;
                            } else {
                                $newLog[] = "Not found";
                                $newLog[] = "Add new wp user from affiliate email";
                                $affiliateWpUser = wp_insert_user( array(
                                    'user_pass' => $this->_generateRandomPassword(),
                                    'user_login' => $affiliateEmail,
                                    'user_email' => $affiliateEmail,
                                ) );

                                if ( !is_wp_error( $affiliateWpUser ) ) {
                                    $newLog[] = "Success. New wp user id {$affiliateWpUser}";
                                    $this->_wpdb->delete(
                                        $this->_tableScheduler,
                                        array(
                                            'user_id' => $affiliateWpUser,
                                        ),
                                        array( '%d', )
                                    );
                                } else {
                                    $msgFailed = $affiliateWpUser->get_error_message();
                                    $newLog[] = "Failed. Error is {$msgFailed}";
                                }
                            }

                            if ( !empty( $affiliateWpUser ) ) {
                                $newLog[] = "Set wp user referrer";
                                update_user_meta( $userId, 'referral', $affiliateWpUser );
                            }
                        }
                    } else {
                        $needSetDefaultReferer = true;
                    }
                } else {
                    $result['stop_schedule'] = true;
                    $newLog[] = "Infusionsoft api failed";
                }
            } else {
                $newLog[] = "Not set";
                $needSetDefaultReferer = true;
            }
        } else {
            $newLog[] = "Had set referer with value {$referrer}";
        }

        if ( $needSetDefaultReferer ) {
            if ( !empty( $defaultReferrer ) ) {
                $newLog[] = "Set wp user referrer using default referrer";
                update_user_meta( $userId, 'referral', $defaultReferrer );
            } else {
                $newLog[] = "Default referrer not set";
            }
        }

        $newLog[] = "Done";
        $result['logs'] = $newLog;
        $result['map_affiliates'] = $mapAffiliates;

        $this->_wpdb->update(
            $this->_tableScheduler,
            array(
                'processed' => 1,
                'result' => maybe_serialize( array_merge( $logs, $newLog ) ),
            ),
            array(
                'user_id' => $userId,
            ),
            array( '%d', '%s', ),
            array( '%d', )
        );

        return $result;
    }

    private function _initTable()
    {
        $sqlTableScheduler = "CREATE TABLE IF NOT EXISTS {$this->_tableScheduler}";
        $sqlTableScheduler .= "( 
            `id` BIGINT(20) NOT NULL AUTO_INCREMENT , 
            `user_id` BIGINT(20) NOT NULL , 
            `processed` TINYINT NOT NULL DEFAULT -1 , 
            `result` TEXT , 
            PRIMARY KEY (`id`) , 
            UNIQUE (`user_id`), 
            INDEX (`processed`)
        ) ENGINE = InnoDB;";
        $this->_wpdb->query( $sqlTableScheduler );
    }

    private function _generateRandomPassword()
    {
        return wp_generate_password();
    }

    private function _getQueueByUser( $userId )
    {
        if ( empty( $userId ) ) {
            return false;
        }

        $sqlGet = $this->_wpdb->prepare(
            "SELECT * FROM {$this->_tableScheduler} WHERE `user_id` = %d",
            $userId
        );

        return $this->_wpdb->get_row( $sqlGet, 'ARRAY_A' );
    }

    /**
     * Disable the cloning of this class.
     * 
     * @return void
     */
    final public function __clone()
    {
        throw new Exception('Feature disabled.');
    }

    /**
     * Disable the wakeup of this class.
     * 
     * @return void
     */
    final public function __wakeup()
    {
        throw new Exception('Feature disabled.');
    }
}